﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using System.Drawing.Imaging;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	abstract class CActGUIBase : CActivity
	{
		// すべての CActGUIBase とその派生クラスはこのリストに登録される。
		public static readonly List<CActGUIBase> Instances = new List<CActGUIBase>();

		public CActGUIパネル ParentPanel { get; private set; }
		public Point Location { get; set; }
		public Size Size { get; set; }
		public int Width
		{
			get { return this.Size.Width; }
			set { this.Size = new Size( Math.Max( value, 0 ), this.Size.Height ); }
		}
		public int Height
		{
			get { return this.Size.Height; }
			set { this.Size = new Size( this.Size.Width, Math.Max( value, 0 ) ); }
		}
		public bool Focused { get; set; }

		// カーソルがコントロールの上にあるときにマウスボタンを押すと、通常はコントロールから次の一連のイベントが発生します。（MSDN; http://msdn.microsoft.com/ja-jp/library/system.windows.forms.control.mouseclick%28v=vs.110%29.aspx ）
		//    1. MouseDown イベント
		//    2. Click イベント
		//    3. MouseClick イベント
		//    4. MouseUp イベント
		public event EventHandler MouseDown = null;
		public event EventHandler Click = null;
		public event EventHandler MouseClick = null;
		public event EventHandler MouseUp = null;
		public event EventHandler MouseHover = null;
		public event EventHandler MouseEnter = null;
		public event EventHandler MouseLeave = null;

		public CActGUIBase( CActGUIパネル ParentPanel )
		{
			CActGUIBase.Instances.Add( this );

			this.ParentPanel = ParentPanel;
			this.Location = new Point( 0, 0 );
			this.Size = new Size( 0, 0 );
			this.Focused = false;
		}

		#region [ IDisposable オーバーライド ]
		//-----------------
		public new void Dispose()
		{
			CActGUIBase.Instances.Remove( this );
			base.Dispose();
		}
		//-----------------
		#endregion


		// ウィンドウから親に送られてくるイベント。MouseHover/Enter/Leave は自前で判定し発火する。
		public void OnWindowMouseDown()
		{
			this.tマウスが上にあるときのウィンドウイベントの再帰処理( ( act ) => { return act.MouseDown; } );
		}
		public void OnWindowClick()
		{
			this.tマウスが上にあるときのウィンドウイベントの再帰処理( ( act ) => { return act.Click; } );
		}
		public void OnWindowMouseClick()
		{
			this.tマウスが上にあるときのウィンドウイベントの再帰処理( ( act ) => { return act.MouseClick; } );
		}
		public void OnWindowMouseUp()
		{
			this.tマウスが上にあるときのウィンドウイベントの再帰処理( ( act ) => { return act.MouseUp; } );
		}

		public static void t角の丸い四角を描画する( Graphics g, Brush brush, int x, int y, int width, int height, int margin )
		{
			if( width < margin * 2 || height < margin * 2 )
			{
				// 小さすぎたら角は丸めない
				g.FillRectangle( brush, x, y, width, height );
			}
			else
			{
				g.FillRectangle( brush, x + margin, y + margin, width - margin * 2, height - margin * 2 );
				g.FillRectangle( brush, x, y + margin, margin, height - margin * 2 );
				g.FillRectangle( brush, x + width - margin, y + margin, margin, height - margin * 2 );
				g.FillRectangle( brush, x + margin, y, width - margin * 2, margin );
				g.FillRectangle( brush, x + margin, y + height - margin, width - margin * 2, margin );
				g.FillPie( brush, new Rectangle( x, y, margin * 2, margin * 2 ), 180f, 90f );											// 左上
				g.FillPie( brush, new Rectangle( x + width - margin * 2, y, margin * 2, margin * 2 ), 270f, 90f );						// 右上
				g.FillPie( brush, new Rectangle( x, y + height - margin * 2, margin * 2, margin * 2 ), 90f, 90f );						// 左下
				g.FillPie( brush, new Rectangle( x + width - margin * 2, y + height - margin * 2, margin * 2, margin * 2 ), 0f, 90f );	// 右下
			}
		}
		public static void t親パネル相対位置で描画する( IntPtr hLockedDevice, CActGUIBase child, CTexture texture )
		{
			if( texture == null )
				return;

			Point pt = child.Location;

			if( child.ParentPanel != null )
				pt += new Size( child.ParentPanel.Location );

			texture.t2D描画( hLockedDevice, pt );
		}

		// 描画スレッドからしか呼び出せないので注意。
		protected bool bカーソルが上にある
		{
			get
			{
				Point ptウィンドウ内位置 = Program.App.Window.PointToClient( Cursor.Position );
				Point pt親GUI内位置 = ptウィンドウ内位置;

				if( this.ParentPanel != null )
					pt親GUI内位置 -= new Size( this.ParentPanel.Location );

				return new Rectangle( this.Location.X, this.Location.Y, this.Width, this.Height ).Contains( pt親GUI内位置 );
			}
		}
		protected bool bMouseHover中 = false;

		protected override void Dispose( bool A_0 )
		{
			// インスタンスリストから自分を除外。
			if( CActGUIBase.Instances.Contains( this ) )
				CActGUIBase.Instances.Remove( this );

			GC.SuppressFinalize( this );
			base.Dispose( A_0 );
		}
		protected override int On進行()
		{
			// 子GUI の呼び出し｡
			foreach( var child in this.list子Activities )
				child.t進行();

			return base.On進行();
		}
		protected override void On描画前()
		{
			// 子GUIの呼び出し

			foreach( var child in this.list子Activities )
				child.t描画前();


			// MouseHover, MouseEnter, MouseLeave イベントの発火有無の確認。

			if( this.bカーソルが上にある )
			{
				if( !this.bMouseHover中 && this.MouseEnter != null )
					this.MouseEnter( this, new EventArgs() );

				this.bMouseHover中 = true;

				if( this.MouseHover != null )
					this.MouseHover( this, new EventArgs() );
			}
			else
			{
				if( this.bMouseHover中 && this.MouseLeave != null )
					this.MouseLeave( this, new EventArgs() );

				this.bMouseHover中 = false;
			}
		}
		protected override void On描画( IntPtr hDevice )
		{
			// 子GUIの呼び出し。後から Add したほど上に描画されることになる。
			
			foreach( var child in this.list子Activities )
				child.t描画( hDevice );


			base.On描画( hDevice );
		}

		private delegate EventHandler DGEventHandler( CActGUIBase act );
		private void tマウスが上にあるときのウィンドウイベントの再帰処理( DGEventHandler dgEventHandler )
		{
			Debug.Assert( this.ParentPanel == null );
			Debug.Assert( this.b活性化してる );


			// 子クラスについてイベントチェックを行う。

			bool b子にイベントを伝搬した = false;

			for( int i = this.list子Activities.Count - 1; i >= 0; i-- )		// チェックは後ろ（＝上）から。
			{
				var child = this.list子Activities[ i ] as CActGUIBase;
				Debug.Assert( child != null );

				if( child.bカーソルが上にある )
				{
					// 子のイベントハンドラを呼び出す。

					if( dgEventHandler( child ) != null )
						dgEventHandler( child )( child, new EventArgs() );

					
					// さらに、sender を child にして親（＝自分）のイベントハンドラも呼び出す。

					if( dgEventHandler( this ) != null )
						dgEventHandler( this )( child, new EventArgs() );


					// 子や親のイベントハンドラを呼び出せたか否かに関係無く、ここでチェック終了。

					b子にイベントを伝搬した = true;
					break;
				}
			}


			// 子にイベントを伝搬しなかったら、自分についてイベントチェックする｡

			if( !b子にイベントを伝搬した )
			{
				if( this.bカーソルが上にある && dgEventHandler( this ) != null )
					dgEventHandler( this )( this, new EventArgs() );		// sender を this にして自分のイベントハンドラを呼び出す。
			}
		}
	}
}
