//
// switch.cpp
// AvP[V̎
//

#include <winsock2.h>
#include <windows.h>
#include <psapi.h>
#include <gdiplus.h>
#include <Dbt.h>

#include <Poco/DOM/DOMParser.h>
#include <Poco/DOM/Document.h>
#include <Poco/DOM/Element.h>
#include <Poco/DOM/NodeList.h>
#include <Poco/Exception.h>
#include <Poco/Channel.h>
#include <Poco/ConsoleChannel.h>
#include <Poco/FileChannel.h>
#include <Poco/FormattingChannel.h>
#include <Poco/format.h>
#include <Poco/Logger.h>
#include <Poco/Thread.h>
#include <Poco/Util/XMLConfiguration.h>
#include <Poco/UnicodeConverter.h>
#include <Poco/PatternFormatter.h>
#include <Poco/Net/HTTPServer.h>
#include <Poco/Net/HTTPServerParams.h>
#include <Poco/Net/ServerSocket.h>

#include "switch.h"
#include "Renderer.h"
#include "CaptureScene.h"
#include "MainScene.h"
#include "UserInterfaceScene.h"
#include "Workspace.h"
#include "WebAPI.h"
#include "ui/UserInterfaceManager.h"

extern "C" {
#define inline _inline
#include <libavutil/avstring.h>
#include <libavcodec/avcodec.h>
#include <libavformat/avformat.h>
#include <libavdevice/avdevice.h>
#include <libswscale/swscale.h>
}

#ifndef _DEBUG
#include <omp.h>
#endif

#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>                // ŌɃCN[hقCBC++̏ꍇBWwb_̒newƂƕςɂȂHH
#ifdef _DEBUG
#define new ::new(_NORMAL_BLOCK,__FILE__,__LINE__)     // ꂪdv
#endif

using Poco::AutoPtr;
using Poco::File;
using Poco::Util::XMLConfiguration;
using Poco::XML::Document;
using Poco::XML::Element;


static TCHAR clsName[] = TEXT("switchClass"); // NX

static Poco::Channel* _logFile;
static Poco::Logger& _log = Poco::Logger::get("");
static Configuration _conf;

static RendererPtr _renderer;
static ui::UserInterfaceManagerPtr _uim;

static std::string _interruptFile;


//-------------------------------------------------------------
// AvP[ṼGg|Cg
// 
//		hInstance     : ݂̃CX^X̃nh
//		hPrevInstance : ȑÕCX^X̃nh
//		lpCmdLine	  : R}hCp[^
//		nCmdShow	  : EBhE̕\
// ߂l
//		0ȊO̒l
//-------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
#if defined(DEBUG) | defined(_DEBUG)
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
//	_CrtSetBreakAlloc(4141);
//	_CrtSetBreakAlloc(3627);
//	_CrtSetBreakAlloc(7048);
#endif
#if defined(DEBUG) | defined(_DEBUG)
#endif
#ifdef _DEBUG
//_CrtDumpMemoryLeaks();
#endif

	if (!guiConfiguration()) return 0;

	HWND hWnd;
	MSG msg;
	// EBhENX̏
	WNDCLASSEX wcex = {
		sizeof(WNDCLASSEX),				// ̍\̂̃TCY
		CS_DBLCLKS,						// EChẼX^C(default)
		WindowProc,						// bZ[W֐̓o^
		0,								// ʏ͎gȂ̂ŏ0
		0,								// ʏ͎gȂ̂ŏ0
		hInstance,						// CX^Xւ̃nh
		NULL,							// ACRiȂj
		LoadCursor(NULL, IDC_ARROW),	// J[\̌`
		NULL, NULL,						// wiȂAj[Ȃ
		clsName,						// NX̎w
		NULL							// ACRiȂj
	};

	// EBhENX̓o^
	if (RegisterClassEx(&wcex) == 0) {
		MessageBox(0, L"EBhENX̓o^Ɏs܂", NULL, MB_OK);
		return 0;	// o^s
	}

	// EBhE̍쐬
	std::wstring wtitle;
	Poco::UnicodeConverter::toUTF16(_conf.title, wtitle);
	if (_conf.fullsceen) {
		// tXN[
		// ʑŜ̕ƍ擾
		int sw = GetSystemMetrics(SM_CXSCREEN);
		int sh = GetSystemMetrics(SM_CYSCREEN);

		hWnd = CreateWindow(
					wcex.lpszClassName,			// o^ĂNX
					wtitle.c_str(), 			// EChE
					WS_POPUP,					// EChEX^Ci|bvAbvEChE쐬j
					0, 							// EChẺ̈ʒu
					0, 							// EChȄc̈ʒu
					_conf.mainRect.right,		// EChE̕
					_conf.mainRect.bottom,		// EChE̍
					NULL,						// eEChẼnhiȗj
					NULL,						// j[qEChẼnh
					hInstance, 					// AvP[VCX^X̃nh
					NULL						// EChE̍쐬f[^
				);

	} else {
		// EBhE[h
		DWORD dwStyle;
		if (_conf.frame) {
			dwStyle = WS_OVERLAPPEDWINDOW;
		} else {
			dwStyle = WS_POPUP;
		}
		hWnd = CreateWindow(clsName,
							wtitle.c_str(),
							dwStyle,
							CW_USEDEFAULT, CW_USEDEFAULT, 
							CW_USEDEFAULT, CW_USEDEFAULT,
							NULL, NULL, hInstance, NULL);

		if (hWnd) {
			// EBhETCYĐݒ肷
			RECT rect;
			int ww, wh;
			int cw, ch;

			// EChEŜ̉̕vZ
			GetWindowRect(hWnd, &rect);		// EChEŜ̃TCY擾
			ww = rect.right - rect.left;	// EChEŜ̉̕vZ
			wh = rect.bottom - rect.top;	// EChEŜ̏̕cvZ
			
			// NCAg̈̊O̕vZ
			GetClientRect(hWnd, &rect);		// NCAg̃TCY̎擾
			cw = rect.right - rect.left;	// NCAg̈ỎvZ
			ch = rect.bottom - rect.top;	// NCAg̈ȌcvZ

			ww = ww - cw;					// NCAg̈ȊOɕKvȕ
			wh = wh - ch;					// NCAg̈ȊOɕKvȍ

			// EBhETCY̍ČvZ
			ww = _conf.mainRect.right + ww;	// KvȃEChE̕
			wh = _conf.mainRect.bottom + wh;	// KvȃEChE̍

			// EChETCY̍Đݒ
			SetWindowPos(hWnd, HWND_TOP, _conf.mainRect.left, _conf.mainRect.top, ww, wh, 0);

			// hbNhbv̎t
			DragAcceptFiles(hWnd, TRUE);
		}
	}
	if (!hWnd) {
		MessageBox(0, L"EBhE̐Ɏs܂", NULL, MB_OK);
		return 0;
	}

	// EBhE̕\
	UpdateWindow(hWnd);
    ShowWindow(hWnd, nCmdShow);

	// WM_PAINTĂ΂Ȃ悤ɂ
	ValidateRect(hWnd, 0);

#ifdef _DEBUG
	_log.information("*** system start (debug)");
#else 
	#pragma omp parallel
	{
		_log.information(Poco::format("*** system start (omp threads x%d)", omp_get_num_threads()));
	}
#endif

	// _[̏
	_renderer = new Renderer();	
	HRESULT hr = _renderer->initialize(hInstance, hWnd);
	if (FAILED(hr)) {
		MessageBox(0, L"_[̏Ɏs܂", NULL, MB_OK);
		return 0;	// s
	}

	_uim = new ui::UserInterfaceManager(*_renderer);
	_uim->initialize();
	// V[̐
	CaptureScenePtr captureScene = NULL;
	if (_conf.useScenes.find("capture") != string::npos) {
		captureScene = new CaptureScene(*_renderer, _uim);
		captureScene->initialize();
		_renderer->addScene("capture", captureScene);
	}
//	WorkspacePtr workspace = new Workspace(_conf.workspaceFile);
//	workspace->parse();
	MainScenePtr mainScene = NULL;
	if (true) {
		mainScene = new MainScene(*_renderer, *_uim, _conf.workspaceFile);
		_renderer->addScene("main", mainScene);
	}
//	UserInterfaceScenePtr uiScene = new UserInterfaceScene(*_renderer, _uim);
//	_renderer->addScene("ui", uiScene);

	Poco::ThreadPool::defaultPool().addCapacity(8);
	Poco::Net::HTTPServerParams* params = new Poco::Net::HTTPServerParams;
	params->setMaxQueued(50);
	params->setMaxThreads(8);
	Poco::Net::ServerSocket socket(9090);
	Poco::Net::HTTPServer* server = new Poco::Net::HTTPServer(new SwitchRequestHandlerFactory(*_renderer), socket, params);
	server->start();

	// bZ[Wѕ`惋[v
	EmptyWorkingSet(GetCurrentProcess());
	LARGE_INTEGER freq;
	LARGE_INTEGER start;
	LARGE_INTEGER current;
	::QueryPerformanceFrequency(&freq);
	::QueryPerformanceCounter(&start);

//	DWORD lastSwapout = 0;
	for (;;) {
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			if (msg.message == WM_QUIT) {
				// PostQuitMessage()Ă΂ꂽ
				break;	//[v̏I
			} else {
				// bZ[W̖|ƃfBXpb`
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}

		} else {
			// 郁bZ[WƂ͕`s
			if (_interruptFile.length() > 0) {
//				scene->prepareInterruptFile(_interruptFile);
				_interruptFile.clear();
			}

			// EBhEĂ鎞`悷邽߂̏
			WINDOWPLACEMENT wndpl;
			GetWindowPlacement(hWnd, &wndpl);	// EChȄԂ擾
			if ((wndpl.showCmd != SW_HIDE) && 
				(wndpl.showCmd != SW_MINIMIZE) &&
				(wndpl.showCmd != SW_SHOWMINIMIZED) &&
				(wndpl.showCmd != SW_SHOWMINNOACTIVE)) {

				// `揈̎s
				::QueryPerformanceCounter(&current);
				DWORD time = (DWORD)((current.QuadPart - start.QuadPart) * 1000 / freq.QuadPart);
				_renderer->renderScene(time);
//				if (lastSwapout == 0 || time - lastSwapout > 3600000) {
//					swapout();
//					lastSwapout = time;
//				}
			}

			timeBeginPeriod(1);
			Sleep(3);
			timeEndPeriod(1);
		}
	}

	_log.information(Poco::format("shutdown web api server: %dthreads", server->currentThreads()));
	server->stop();
	// while (server->currentThreads() > 0) Sleep(200);
	Sleep(1000);
	SAFE_DELETE(server);

	_log.information("shutdown system");
	SAFE_DELETE(_renderer);
	SAFE_DELETE(_uim);
	saveConfiguration();
	_logFile->release();
//	_log.shutdown();
	CoUninitialize();

	return (int)msg.wParam;
}



//-------------------------------------------------------------
// bZ[WpR[obN֐
// 
//		hWnd	: EBhEnh
//		msg		: bZ[W
//		wParam	: bZ[W̍ŏ̃p[^
//		lParam	: bZ[W2Ԗڂ̃p[^
// ߂l
//		bZ[W
//-------------------------------------------------------------
LRESULT CALLBACK WindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg) {
		case WM_CREATE:
			::ShowCursor(FALSE);
			break;

		case WM_CLOSE:					// EChEꂽ
			::ShowCursor(TRUE);
			PostQuitMessage(0);			// AvP[VI
			break;
		case WM_SETFOCUS:
			break;
		case WM_KILLFOCUS:
			break;

		case WM_IME_SETCONTEXT:
			lParam &= ~ISC_SHOWUIALL;
			break;
		case WM_IME_STARTCOMPOSITION:
		case WM_IME_COMPOSITION:
		case WM_IME_ENDCOMPOSITION:
			return 0;
		case WM_IME_NOTIFY:
			switch(wParam){
			case IMN_OPENSTATUSWINDOW:
			case IMN_CLOSESTATUSWINDOW:
			case IMN_OPENCANDIDATE:
			case IMN_CHANGECANDIDATE:
			case IMN_CLOSECANDIDATE:
				return 0;
			default:
				return DefWindowProc(hWnd, msg, wParam, lParam);
			}

		case WM_KEYDOWN:
			if (wParam == VK_ESCAPE) {
				PostQuitMessage(0);
			} else {
				bool shift = GetKeyState(VK_SHIFT) < 0;
				bool ctrl = GetKeyState(VK_CONTROL) < 0;
				if (_renderer) _renderer->notifyKeyDown(wParam, shift, ctrl);
			}
			break;
		case WM_KEYUP:
			{
				bool shift = GetKeyState(VK_SHIFT) < 0;
				bool ctrl = GetKeyState(VK_CONTROL) < 0;
				if (ctrl && wParam == 'S') {
					swapout();
				} else {
					if (_renderer) _renderer->notifyKeyUp(wParam, shift, ctrl);
				}
			}
			break;

		case WM_MOUSEMOVE:
			if (_uim) _uim->notifyMouseMove(LOWORD(lParam), HIWORD(lParam));
			break;
		case WM_MOUSEWHEEL:
			if (_uim) _uim->notifyMouseWheel((SHORT)HIWORD(wParam));
			break;
		case WM_LBUTTONDOWN:
			if (_uim) _uim->notifyButtonDownL(LOWORD(lParam), HIWORD(lParam));
			::SetCapture(hWnd);
			break;
		case WM_LBUTTONUP:
			if (_uim) _uim->notifyButtonUpL(LOWORD(lParam), HIWORD(lParam));
			::ReleaseCapture();
			break;
		case WM_RBUTTONDOWN:
			_uim->notifyButtonDownR(LOWORD(lParam), HIWORD(lParam));
			::SetCapture(hWnd);
			break;
		case WM_RBUTTONUP:
			if (_uim) _uim->notifyButtonUpR(LOWORD(lParam), HIWORD(lParam));
			::ReleaseCapture();
			break;

		case WM_DROPFILES:
			{
				HDROP hDrop = (HDROP)wParam; /* HDROP擾 */
				vector<WCHAR> dropFile(255);
				DragQueryFile(hDrop, 0, &dropFile[0], 256); /* ŏ̃t@C擾 */
				DragFinish(hDrop); /* hbv̏I */
				Poco::UnicodeConverter::toUTF8(&dropFile[0], _interruptFile);
			}
			break;

		case WM_DEVICECHANGE:
			{
				switch (wParam) {
				case DBT_DEVICEARRIVAL:
					{
						DEV_BROADCAST_HDR* data = (DEV_BROADCAST_HDR*)lParam;
						if (data && data->dbch_devicetype == DBT_DEVTYP_VOLUME) {
							DEV_BROADCAST_VOLUME* extend = (DEV_BROADCAST_VOLUME*)data;
							if (extend && _renderer) _renderer->notifyAddDrive(extend->dbcv_unitmask);
						}
					}
					break;
				case DBT_DEVNODES_CHANGED:
					_renderer->notifyDeviceChanged();
					break;
				}
			}
			break;

		default:
			return DefWindowProc(hWnd, msg, wParam, lParam);
    }
    return 0;
}


// GUI̐ݒ
bool guiConfiguration()
{
	// ffmpeg̏
	avcodec_register_all();
	avdevice_register_all();
	av_register_all();

	try {
		XMLConfiguration* xml = new XMLConfiguration("switch-config.xml");
		Poco::PatternFormatter* pat = new Poco::PatternFormatter(xml->getString("log[@pattern]", "%Y-%m-%d %H:%M:%S.%c %N[%T]:%t"));
		pat->setProperty(Poco::PatternFormatter::PROP_TIMES, "local");
		Poco::FormattingChannel* fc = new Poco::FormattingChannel(pat);
//		_logFile = new Poco::ConsoleChannel();
		_logFile = new Poco::FileChannel(xml->getString("log", "switch.log"));
		fc->setChannel(_logFile);
		_log.setChannel(fc);
		// [Jw
		fc->setProperty(Poco::FileChannel::PROP_TIMES, "local");
		// A[JCut@Cւ̕t[number/timestamp] (t)
		fc->setProperty(Poco::FileChannel::PROP_ARCHIVE, xml->getString("log[@archive]", "timestamp"));
		// k[true/false] ()
		fc->setProperty(Poco::FileChannel::PROP_COMPRESS, xml->getString("log[@compress]", "true"));
		// [e[VP[never/[day,][hh]:mm/daily/weekly/monthly/<n>minutes/hours/days/weeks/months/<n>/<n>K/<n>M] ()
		fc->setProperty(Poco::FileChannel::PROP_ROTATION, xml->getString("log[@rotation]", "daily"));
		// ێ[<n>seconds/<n>minutes/<n>hours/<n>days/<n>weeks/<n>months] (5)
		fc->setProperty(Poco::FileChannel::PROP_PURGEAGE, xml->getString("log[@purgeage]", "5days"));
		fc->release();
		pat->release();
		_log.information("*** configuration");

		_conf.title = xml->getString("title", "switch");
		_conf.mainRect.left = xml->getInt("display.x", 0);
		_conf.mainRect.top = xml->getInt("display.y", 0);
		int w = xml->getInt("display.width", 1024);
		int h = xml->getInt("display.height", 768);
		_conf.mainRect.right = w;
		_conf.mainRect.bottom = h;
		_conf.mainRate = xml->getInt("display.rate", D3DPRESENT_RATE_DEFAULT);
		_conf.subRect.left = xml->getInt("display[1].x", _conf.mainRect.left);
		_conf.subRect.top = xml->getInt("display[1].y", _conf.mainRect.top);
		_conf.subRect.right = xml->getInt("display[1].width", _conf.mainRect.right);
		_conf.subRect.bottom = xml->getInt("display[1].height", _conf.mainRect.bottom);
		_conf.subRate = xml->getInt("display[1].rate", _conf.mainRate);
		_conf.frameIntervals = xml->getInt("display.frameIntervals", 3);
		_conf.frame = xml->getBool("display.frame", true);
		_conf.fullsceen = xml->getBool("display.fullscreen", true);
		_conf.draggable = xml->getBool("display.draggable", true);
		_conf.mouse = xml->getBool("display.mouse", true);
		string windowStyles(_conf.fullsceen?"fullscreen":"window");
		_log.information(Poco::format("display %dx%d@%d %s", w, h, _conf.mainRate, windowStyles));
		_conf.useClip = xml->getBool("display.clip.use", false);
		_conf.clipRect.left = xml->getInt("display.clip.x1", 0);
		_conf.clipRect.top = xml->getInt("display.clip.y1", 0);
		_conf.clipRect.right = xml->getInt("display.clip.x2", 0);
		_conf.clipRect.bottom = xml->getInt("display.clip.y2", 0);
		string useClip(_conf.useClip?"use":"not use");
		_log.information(Poco::format("clip [%s] %ld,%ld %ldx%ld", useClip, _conf.clipRect.left, _conf.clipRect.top, _conf.clipRect.right, _conf.clipRect.bottom));

		int cw = xml->getInt("display.split.width", w);
		int ch = xml->getInt("display.split.height", h);
		int cycles = xml->getInt("display.split.cycles", h / ch);
		_conf.splitSize.cx = cw;
		_conf.splitSize.cy = ch;
		_conf.stageRect.left = xml->getInt("stage.x", 0);
		_conf.stageRect.top = xml->getInt("stage.y", 0);
		_conf.stageRect.right = xml->getInt("stage.width", w * cycles);
		_conf.stageRect.bottom = xml->getInt("stage.height", ch);
		_conf.splitCycles = cycles;
		string splitType = xml->getString("display.split.type", "none");
		if (splitType == "vertical" || splitType == "vertical-down") {
			_conf.splitType = 1;
		} else if (splitType == "vertical-up") {
			_conf.splitType = 2;
		} else if (splitType == "horizontal") {
			_conf.splitType = 11;
		} else {
			_conf.splitType = 0;
		}
		_log.information(Poco::format("stage (%ld,%ld) %ldx%ld", _conf.stageRect.left, _conf.stageRect.top, _conf.stageRect.right, _conf.stageRect.bottom));
		_log.information(Poco::format("split <%s:%d> %dx%d x%d", splitType, _conf.splitType, cw, ch, cycles));

		_conf.useScenes = xml->getString("scenes", "main,operation");
		_conf.luminance = xml->getInt("stage.luminance", 100);
		_conf.viewStatus = xml->getBool("stage.viewStatus", false);

		_conf.imageSplitWidth = xml->getInt("stage.imageSplitWidth", 0);
		if (xml->hasProperty("stage.text")) {
			string s;
			Poco::UnicodeConverter::toUTF8(L"lr SVbN", s);
			_conf.textFont = xml->getString("stage.text.font", s);
			string style = xml->getString("stage.text.style");
			if (style == "bold") {
				_conf.textStyle = Gdiplus::FontStyleBold;
			} else if (style == "italic") {
				_conf.textStyle = Gdiplus::FontStyleItalic;
			} else if (style == "bolditalic") {
				_conf.textStyle = Gdiplus::FontStyleBoldItalic;
			} else {
				_conf.textStyle = Gdiplus::FontStyleRegular;
			}
			_conf.textHeight = xml->getInt("stage.text.height", _conf.stageRect.bottom - 2);
		} else {
			string s;
			Poco::UnicodeConverter::toUTF8(L"lr SVbN", s);
			_conf.textFont = s;
			_conf.textStyle = Gdiplus::FontStyleRegular;
			_conf.textHeight = _conf.stageRect.bottom - 2;
		}

		string defaultFont = xml->getString("ui.defaultFont", "");
		wstring ws;
		Poco::UnicodeConverter::toUTF16(defaultFont, ws);
		_conf.defaultFont = ws;
		_conf.asciiFont = xml->getString("ui.asciiFont", "Defactica");
		_conf.multiByteFont = xml->getString("ui.multiByteFont", "A-OTF-ShinGoPro-Regular.ttf");
//		_conf.vpCommandFile = xml->getString("vpCommand", "");
//		_conf.monitorFile = xml->getString("monitor", "");
		_conf.dataRoot = Path(xml->getString("data-root", "")).absolute();
		_log.information(Poco::format("data root: %s", _conf.dataRoot.toString()));
		_conf.workspaceFile = Path(_conf.dataRoot, xml->getString("workspace", "workspace.xml"));
		_log.information(Poco::format("workspace: %s", _conf.workspaceFile.toString()));
		_conf.newsURL = xml->getString("newsURL", "https://led.avix.co.jp:8080/news");
		xml->release();
		return true;
	} catch (Poco::Exception& ex) {
		string s;
		Poco::UnicodeConverter::toUTF8(L"ݒt@C(switch-config.xml)mFĂ\nu%sv", s);
		wstring utf16;
		Poco::UnicodeConverter::toUTF16(Poco::format(s, ex.displayText()), utf16);
		::MessageBox(HWND_DESKTOP, utf16.c_str(), L"G[", MB_OK);
		_log.warning(ex.displayText());
	}
	return false;
}

Configuration& config() {
	return _conf;
}

void saveConfiguration() {
	_log.information("save configuration");
	try {
		Poco::Util::XMLConfiguration* xml = new Poco::Util::XMLConfiguration("switch-config.xml");
		if (xml) {
			xml->setInt("stage.luminnace", _conf.luminance);
			xml->setBool("stage.viewStatus", _conf.viewStatus);
			xml->save("switch-config.xml");
			xml->release();
		}
	} catch (Poco::Exception& ex) {
		_log.warning(Poco::format("failed save configuration file: %s", ex.displayText()));
	}
}

// XbvAEg
void swapout() {
	_log.information("*** exec memory swapout");
	EmptyWorkingSet(GetCurrentProcess());
	return;

	DWORD idProcess[1024];
	DWORD bsize = 0;
	/* vZXʎq擾 */
	if (EnumProcesses(idProcess, sizeof(idProcess), &bsize) == FALSE) {
		_log.warning("failed EnumProcesses()");
		return;
	}
	_log.information("*** exec memory swapout");
	int proc_num = bsize / sizeof(DWORD);
	WCHAR name[1024];
	for (int i = 0; i < proc_num; i++) {
		/* vZXnh擾 */
		HANDLE	handle = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_SET_QUOTA | PROCESS_VM_READ, FALSE, idProcess[i]);
		if (handle != NULL) {
			bool swapouted = false;
			if (handle != GetCurrentProcess()) {
				// ȊÕvZXXbvAEg
				swapouted = EmptyWorkingSet(handle)==TRUE;
			}
			HMODULE	module[1024];
			if (EnumProcessModules(handle, module, sizeof(module), &bsize) != FALSE ) {
				/* vZX擾 */
				if (GetModuleBaseName(handle, module[0], name, sizeof(name)) > 0) {
					PROCESS_MEMORY_COUNTERS pmc = {0};
					GetProcessMemoryInfo(handle, &pmc, sizeof(PROCESS_MEMORY_COUNTERS));
					int mem = pmc.WorkingSetSize / 1024;
					string swapout = swapouted?"<swapouted>":"";
					string nameUTF8;
					Poco::UnicodeConverter::toUTF8(wstring(name), nameUTF8);
					_log.information(Poco::format("process: %20s %05dkB%s", nameUTF8, mem, swapout));
				}
			}
			CloseHandle(handle);
		}
	}
}
