#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#define DIRECTINPUT_VERSION 0x0800
#include <dinput.h>
#include <Poco/ActiveMethod.h>
#include <Poco/ActiveResult.h>
#include <Poco/Logger.h>
#include <Poco/Mutex.h>
#include <Poco/Thread.h>
#include <Poco/Runnable.h>
#include <map>
#include <string>
#include <vector>
#include <queue>

#include "Common.h"

#include "Container.h"
#include "Renderer.h"
#include "Scene.h"
#include "Transition.h"
#include "ui/UserInterfaceManager.h"
#include "Workspace.h"

using std::string;
using std::vector;
using std::queue;
using std::map;

using Poco::ActiveMethod;
using Poco::ActiveResult;


struct PlayParameters
{
	string playlistID;
	int i;
	string action;
	string transition;
};

struct RemovableMediaArgs {
	const string& driveLetter;
};

class MainScene: public Scene
{
private:
	Poco::FastMutex _lock;
	Poco::FastMutex _workspaceLock;

	ui::UserInterfaceManager& _uim;
	Path& _workspaceFile;
	WorkspacePtr _workspace;
	WorkspacePtr _updatedWorkspace;

	DWORD _frame;
	bool _startup;
	bool _autoStart;
	int _luminance;

	vector<ContainerPtr> _contents;
	int _currentContent;
	bool _preparing;

	/** ĐRec */
	PlayParameters _playCurrent;

	/** vCXg */
	LPDIRECT3DTEXTURE9 _playlistName;
	/** Đ̃Rec */
	LPDIRECT3DTEXTURE9 _currentName;

	vector<PlayParameters> _nextStack;
	int _nextStackTime;

	/** ĐRec */
	PlayParameters _playNext;

	/** ̃vCXg */
	LPDIRECT3DTEXTURE9 _nextPlaylistName;
	/** ̃Rec */
	LPDIRECT3DTEXTURE9 _nextName;

	vector<PlayParameters> _prepareStack;
	int _prepareStackTime;

	/** ؑ֏Rec */
	PlayParameters _playPrepared;

	/** ؑ֏Rec */
	ContainerPtr _prepared;

	/** ؑ֏̃vCXg */
	LPDIRECT3DTEXTURE9 _preparedPlaylistName;
	/** ؑ֏̃Rec */
	LPDIRECT3DTEXTURE9 _preparedName;

	/** Đ */
	int _playCount;
	bool _doPrepareNext;
	bool _preparingNext;
	/** ؑփtO */
	bool _doSwitchNext;
	/** ؑ֏Rec̐ؑփtO */
	bool _doSwitchPrepared;
	/** gWV */
	TransitionPtr _transition;

	/** ݎ */
	string _nowTime;
	/** ݎ̕b */
	int _timeSecond;

	bool _initializing;
	bool _running;

	/** USBACR */
	LPDIRECT3DTEXTURE9 _removableIcon;
	string _addRemovable;
	float _removableAlpha;
	float _removableCover;
	unsigned long _copySize;
	unsigned long _currentCopySize;
	int _copyProgress;
	int _currentCopyProgress;

	vector<ContainerPtr> _delayReleases;


	void run();

	/** ؑ֗pRec̏ */
	bool prepareContent(const PlayParameters& args);

	/** ĐRec܂ */
	bool prepareNextContent(const PlayParameters& args);

	/** ContainerɎw肳ꂽvCXg̃Rec܂ */
	bool prepareMedia(ContainerPtr container, const string& playlistID, const int i = 0);

	void addRemovableMedia(const string& driveLetter);

	int copyFiles(const string& src, const string& dst);

public:
	MainScene(Renderer& renderer, ui::UserInterfaceManager& uim, Path& workspaceFile);

	virtual ~MainScene();

	void delayedReleaseContainer();

	/**  */
	bool initialize();

	/** ݒ肳ĂWorkspace擾܂ */
	Workspace& getWorkspace();

	void notifyKey(const int keycode, const bool shift, const bool ctrl);

	/** ؑ֗pRecX^bN܂ */
	bool stackPrepareContent(string& playlistID, int i = 0);

	/** vCXgeLXg擾 */
	const string getPlaylistText(const string& playlistID);

	/** vCXgeLXgݒ */
	bool setPlaylistText(const string& playlistID, const string& text);

	/** Pxݒ */
	void setLuminance(int i);

	/** JڃANVݒ */
	void setAction(string& action);

	/** gWVݒ */
	void setTransition(string& transition);

	/** ؑ֗pRec̏(ANeBu) */
	ActiveMethod<bool, PlayParameters, MainScene> activePrepareContent;

	/** 蓮Őؑւs܂ */
	bool switchContent();

	/** workspaceXV */
	bool updateWorkspace();

	/** ĐRec(ANeBu) */
	ActiveMethod<bool, PlayParameters, MainScene> activePrepareNextContent;

	/** [oufBA̒ǉ(ANeBu) */
	ActiveMethod<void, string, MainScene> activeAddRemovableMedia;

	/** t[ōs */
	virtual void process();

	/**
	 * t[`
	 * RecȂǂ̃C`n
	 */
	virtual void draw1();

	/**
	 * t[`
	 * ɃXe[^Xn
	 */
	virtual void draw2();
};

typedef MainScene* MainScenePtr;
