#pragma once

#include <Poco/ActiveMethod.h>
#include <Poco/ActiveResult.h>
#include <Poco/Mutex.h>
#include <Poco/Thread.h>
#include <Poco/Runnable.h>

#include "Content.h"
#include "CaptureScene.h"
#include "MediaItem.h"
#include "FFMovieContent.h"
#include "PerformanceTimer.h"
#include "Renderer.h"
#include "Workspace.h"

#include <queue>

using std::queue;
using std::string;
using std::wstring;


/**
 * OpenCVpRegNX.
 * OpenCV̎Regł
 */
class CvContent: public Content
{
private:
	Poco::FastMutex _lock;

	CaptureScenePtr _scene;

	float _subtract;
	int _intervalDiff;
	int _intervalSmall;

	int _clipX;
	int _clipY;
	int _clipW;
	int _clipH;

	LPD3DXEFFECT _fx;
	LPDIRECT3DTEXTURE9 _small1;
	LPDIRECT3DTEXTURE9 _small2;
	LPDIRECT3DTEXTURE9 _diff;
	LPDIRECT3DSURFACE9 _diff2;
	LPDIRECT3DTEXTURE9 _photo;
	int _detectThreshold;
	int _diffCount;

	string _normalFile;
	MediaItemPtr _normalItem;
	FFMovieContentPtr _normalMovie;
	vector<string> _detectFiles;
	MediaItemPtr _detectedItem;
	FFMovieContentPtr _detectedMovie;

	int _detectCount;
	bool _detected;
	int _doShutter;
	int _viewPhoto;

	bool _finished;
	bool _playing;
	PerformanceTimer _playTimer;

	DWORD _statusFrame;
	string _status;

public:
	/** RXgN^ */
	CvContent(Renderer& renderer, int splitType);

	/** fXgN^ */
	virtual ~CvContent();

	/** ݒ̕ۑ */
	void saveConfiguration();

	/**  */
	void initialize();

	/** t@CI[v܂ */
	bool open(const MediaItemPtr media, const int offset = 0);

	Poco::ActiveMethod<void, void, CvContent> activeOpenDetectMovie;
	void openDetectMovie();

	/** Đ */
	void play();

	/** ~ */
	void stop();

	/** ĐIɂܒ~邩ǂ */
	bool useFastStop();

	/** Đǂ  */
	const bool playing() const;

	const bool finished();

	/** t@CN[Y܂ */
	void close();

	/** `ȊȌ */
	void process(const DWORD& frame);

	/** `揈 */
	void draw(const DWORD& frame);
};

typedef CvContent* CvContentPtr;
