using System;
using System.IO;

using SystemNeo;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class Curve
	{
		#region private static fields
		private static readonly CollectionFormatter valuesFormatter = new CollectionFormatter();
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public int Count { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public Fraction Gamma { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public ushort[] Values { get; private set; }

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static Curve()
		{
			valuesFormatter.MaxCount = 16;
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal Curve(BinaryReaderNeo reader)
		{
			this.Count = reader.ReadInt32();
			switch (this.Count) {
			case 0:
				break;
			case 1:
				this.Gamma = new Fraction(reader.ReadUInt16(), 0x100);
				break;
			default:
				this.Values = new ushort[this.Count];
				for (int i = 0; i < this.Count; i++) {
					this.Values[i] = reader.ReadUInt16();
				}
				break;
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("{Count=");
			sw.Write(this.Count.ToString("N0"));
			switch (this.Count) {
			case 0:
				break;
			case 1:
				sw.Write(", Gamma=");
				FractionFormatter.Default.WriteTo(sw, this.Gamma);
				break;
			default:
				sw.Write(", CurveValues=");
				valuesFormatter.WriteTo(sw, this.Values);
				break;
			}
			sw.Write("}");
			return sw.ToString();
		}
	}
}
