using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using SystemNeo.IO;

namespace SystemNeo.Drawing.Imaging
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class IptcIimDataSet
	{
		#region private static fields
		private static readonly IDictionary<IptcIimRecordType, IDictionary<int, IptcIimDataSet>> dic
				= new Dictionary<IptcIimRecordType, IDictionary<int, IptcIimDataSet>>();
		#endregion

		#region private fields
		private readonly object conversion;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public byte DataSetNumber { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string Name { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public IptcIimRecordType RecordType { get; private set; }

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static IptcIimDataSet()
		{
			dic[IptcIimRecordType.Envelope] = new Dictionary<int, IptcIimDataSet>() {
				{ 90, new IptcIimDataSet("CodedCharacterSet", Encoding.ASCII)}
			};
			dic[IptcIimRecordType.Application2] = new Dictionary<int, IptcIimDataSet>() {
				{  0, new IptcIimDataSet("RecordVersion",     typeof(ushort))},
				{  5, new IptcIimDataSet("ObjectName",        Encoding.ASCII)},
				{ 80, new IptcIimDataSet("By-line",           Encoding.ASCII)},
				{116, new IptcIimDataSet("CopyrightNotice",   Encoding.ASCII)},
				{117, new IptcIimDataSet(null,                Encoding.ASCII)},
				{118, new IptcIimDataSet("Contact",           Encoding.ASCII)},
				{120, new IptcIimDataSet("Caption/Abstract",  Encoding.ASCII)}
			};
		}

		// private RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="conversion"></param>
		private IptcIimDataSet(string name, object conversion)
		{
			this.Name = name;
			this.conversion = conversion;
		}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="recordType"></param>
		/// <param name="dataSetNumber"></param>
		/// <returns></returns>
		internal static IptcIimDataSet GetDataSet(
				IptcIimRecordType recordType, byte dataSetNumber)
		{
			IDictionary<int, IptcIimDataSet> d = dic[recordType];
			if (d == null) {
				return null;
			} else {
				IptcIimDataSet ds = d[dataSetNumber];
				ds.RecordType = recordType;
				ds.DataSetNumber = dataSetNumber;
				return ds;
			}
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bytes"></param>
		/// <returns></returns>
		internal object Convert(byte[] bytes)
		{
			var reader = new BinaryReaderNeo(bytes, ByteOrder.BigEndian, Encoding.ASCII);
			if (this.conversion.Equals(typeof(ushort))) {
				return reader.ReadUInt16();
			}
			if (this.conversion is Encoding) {
				return ((Encoding)this.conversion).GetString(bytes);
			}
			return bytes;
		}
	}
}
