using System;
using System.Collections;
using System.IO;
using System.Text;

using SystemNeo;
using SystemNeo.Drawing.Imaging.Icc;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class App2SegmentContent : SegmentContent
	{
		#region private static fields
		private const int firstEntryOffset = 128;
		private const string idValue = "ICC_PROFILE\0";
		private static readonly Formatter formatter = new Formatter();
		private static readonly CollectionFormatter entriesFormatter
				= new CollectionFormatter() {
					BeginBracket = "[" + Environment.NewLine + CharUtil.Tab,
					EndBracket = Environment.NewLine + "]",
					Separator = "," + Environment.NewLine + CharUtil.Tab
				};
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public IccTagElement[] TagElements { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public IccProfileHeader Header { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string Id { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name='reader'></param>
		internal App2SegmentContent(BinaryReaderNeo reader)
		{
			this.Id = reader.ReadString(idValue.Length);
			if (this.Id != idValue) {
				string msg = "APP2IDsłB" + new QuotedStringFormatter().ToString(this.Id);
				throw new BadImageFormatException(msg);
			}
			ushort dummy1 = reader.ReadUInt16();
			long basePosition = reader.Position;
			this.Header = new IccProfileHeader(reader, basePosition);
			reader.Position = basePosition + firstEntryOffset;
			int count = reader.ReadInt32();
			this.TagElements = new IccTagElement[count];
			for (int i = 0; i < count; i++) {
				this.TagElements[i] = new IccTagElement(reader, basePosition);
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("Id=");
			sw.Write(this.Id.TrimEnd('\0'));
			sw.Write(", Header=");
			sw.Write(this.Header);
			sw.Write(", TagElements=");
			entriesFormatter.WriteTo(sw, this.TagElements);
			return sw.ToString();
		}
	}
}
