using System;
using System.IO;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class BinarySegmentContent : SegmentContent
	{
		#region private static fields
		private static readonly ByteArrayFormatter dataFormatter = new ByteArrayFormatter();
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public byte[] Bytes { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string Id { get; private set; }

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static BinarySegmentContent()
		{
			dataFormatter.MaxCount = 20;
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		/// <param name="hasId"></param>
		internal BinarySegmentContent(BinaryReaderNeo reader, bool hasId)
		{
			if (hasId) {
				string s = reader.ReadString('\0');
				this.Id = s.Substring(0, s.Length - 1);
				reader.Seek(-1);        // '\0' ̕߂
			}
			this.Bytes = reader.ReadToEnd();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			if (this.Id != null) {
				sw.Write("Id=");
				sw.Write(this.Id);
				sw.Write(", ");
			}
			sw.Write("Data=");
			dataFormatter.WriteTo(sw, this.Bytes);
			return sw.ToString();
		}
	}
}
