using System;

using SystemNeo;
using SystemNeo.IO;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class DqtSegmentContent : SegmentContent
	{
		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public byte QuantizationPrecision { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public int TableId { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal DqtSegmentContent(BinaryReaderNeo reader)
		{
			byte upper;
			byte lower;
			ObjectUtil.SplitBits(reader.ReadByte(), out upper, out lower);
			this.QuantizationPrecision = (byte)((upper + 1) * 8);       // 0: 8bitA1: 16bit
			this.TableId = lower;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			return string.Format("QuantizationPrecision={0}, TableId={1}",
					this.QuantizationPrecision, this.TableId);
		}
	}
}
