using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Windows.Forms;

using SystemNeo;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// Rg[Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class ControlUtil
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="e"></param>
		/// <param name="s"></param>
		public static void DrawString(Control control, DrawItemEventArgs e, string s)
		{
			DrawString(control, e, s, null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="e"></param>
		/// <param name="s"></param>
		/// <param name="format"></param>
		public static void DrawString(
				Control control, DrawItemEventArgs e, string s, StringFormat format)
		{
			ArgumentUtil.AssertNull(control, "control");
			ArgumentUtil.AssertNull(e, "e");
			if (s != null && s.Length > 0) {
				e.Graphics.DrawString(s, e.Font, new SolidBrush(e.ForeColor), e.Bounds, format);
			}
		}

		/// <summary>
		/// w̃Rg[ɐݒ肳ĂtHgƑOiFŁAw肵`悵܂B
		/// </summary>
		/// <param name="control"></param>
		/// <param name="graphics"></param>
		/// <param name="s">`悷镶B</param>
		/// <param name="point"></param>
		public static void DrawString(Control control, Graphics graphics, string s, PointF point)
		{
			DrawString(control, graphics, s, point, null);
		}

		/// <summary>
		/// w̃Rg[ɐݒ肳ĂtHgƑOiFŁAw肵`悵܂B
		/// </summary>
		/// <param name="control"></param>
		/// <param name="graphics"></param>
		/// <param name="s">`悷镶B</param>
		/// <param name="point"></param>
		/// <param name="format"></param>
		public static void DrawString(Control control,
				Graphics graphics, string s, PointF point, StringFormat format)
		{
			ArgumentUtil.AssertNull(control, "control");
			ArgumentUtil.AssertNull(graphics, "graphics");
			if (s != null && s.Length > 0) {
				var brush = new SolidBrush(control.ForeColor);
				graphics.DrawString(s, control.Font, brush, point, format);
			}
		}

		/// <summary>
		/// w̃Rg[ɐݒ肳ĂtHgƑOiFŁAw肵`悵܂B
		/// </summary>
		/// <param name="control"></param>
		/// <param name="graphics"></param>
		/// <param name="s">`悷镶B</param>
		/// <param name="layoutRectangle"></param>
		public static void DrawString(
				Control control, Graphics graphics, string s, RectangleF layoutRectangle)
		{
			DrawString(control, graphics, s, layoutRectangle, null);
		}

		/// <summary>
		/// w̃Rg[ɐݒ肳ĂtHgƑOiFŁAw肵`悵܂B
		/// </summary>
		/// <param name="control"></param>
		/// <param name="graphics"></param>
		/// <param name="s">`悷镶B</param>
		/// <param name="layoutRectangle"></param>
		/// <param name="format"></param>
		public static void DrawString(Control control,
				Graphics graphics, string s, RectangleF layoutRectangle, StringFormat format)
		{
			ArgumentUtil.AssertNull(control, "control");
			ArgumentUtil.AssertNull(graphics, "graphics");
			if (s != null && s != string.Empty) {
				var brush = new SolidBrush(control.ForeColor);
				graphics.DrawString(s, control.Font, brush, layoutRectangle, format);
			}
		}

		/// <summary>
		/// w肵Rg[Ń_uobt@OLɂ܂B
		/// </summary>
		/// <param name="control"></param>
		public static void EnableDoubleBuffering(Control control)
		{
			ArgumentUtil.AssertNull(control, "control");
			BindingFlags bindingAttr = BindingFlags.Instance | BindingFlags.NonPublic;
			var paramTypes = new Type[] {typeof(ControlStyles), typeof(bool)};
			MethodInfo method = typeof(Control).GetMethod(
					"SetStyle", bindingAttr, null, paramTypes, null);
			ControlStyles styles = ControlStyles.DoubleBuffer
					| ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint;
			method.Invoke(control, new object[] {styles, true});
			method = typeof(Control).GetMethod(
					"UpdateStyles", bindingAttr, null, new Type[] {}, null);
			method.Invoke(control, null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <returns></returns>
		public static T GetFlags<T>(IEnumerable e) where T : struct
		{
			return EnumUtil.GetFlags<T>(e, "Checked", "Tag");
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="method"></param>
		public static void Invoke(Control control, Action method)
		{
			InvokeInternal(control, method);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		public static void Invoke<T1>(Control control, Action<T1> method, T1 arg1)
		{
			InvokeInternal(control, method, arg1);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		public static void Invoke<T1, T2>(Control control, Action<T1, T2> method, T1 arg1, T2 arg2)
		{
			InvokeInternal(control, method, arg1, arg2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		public static void Invoke<T1, T2, T3>(
				Control control, Action<T1, T2, T3> method, T1 arg1, T2 arg2, T3 arg3)
		{
			InvokeInternal(control, method, arg1, arg2, arg3);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		public static void Invoke<T1, T2, T3, T4>(Control control,
				Action<T1, T2, T3, T4> method, T1 arg1, T2 arg2, T3 arg3, T4 arg4)
		{
			InvokeInternal(control, method, arg1, arg2, arg3, arg4);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <typeparam name="T5"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		/// <param name="arg5"></param>
		public static void Invoke<T1, T2, T3, T4, T5>(
				Control control, Action5<T1, T2, T3, T4, T5> method,
				T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5)
		{
			InvokeInternal(control, method, arg1, arg2, arg3, arg4, arg5);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TReturn"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <returns></returns>
		public static TReturn Invoke<TReturn>(Control control, Func<TReturn> method)
		{
			return InvokeInternal<TReturn>(control, method);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="TReturn"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <returns></returns>
		public static TReturn Invoke<T1, TReturn>(
				Control control, Func<T1, TReturn> method, T1 arg1)
		{
			return InvokeInternal<TReturn>(control, method, arg1);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="TReturn"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <returns></returns>
		public static TReturn Invoke<T1, T2, TReturn>(
				Control control, Func<T1, T2, TReturn> method, T1 arg1, T2 arg2)
		{
			return InvokeInternal<TReturn>(control, method, arg1, arg2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="TReturn"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <returns></returns>
		public static TReturn Invoke<T1, T2, T3, TReturn>(Control control,
				Func<T1, T2, T3, TReturn> method, T1 arg1, T2 arg2, T3 arg3)
		{
			return InvokeInternal<TReturn>(control, method, arg1, arg2, arg3);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <typeparam name="TReturn"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		/// <returns></returns>
		public static TReturn Invoke<T1, T2, T3, T4, TReturn>(Control control,
				Func<T1, T2, T3, T4, TReturn> method, T1 arg1, T2 arg2, T3 arg3, T4 arg4)
		{
			return InvokeInternal<TReturn>(control, method, arg1, arg2, arg3, arg4);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <typeparam name="T5"></typeparam>
		/// <typeparam name="TReturn"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		/// <param name="arg5"></param>
		/// <returns></returns>
		public static TReturn Invoke<T1, T2, T3, T4, T5, TReturn>(
				Control control, Func5<T1, T2, T3, T4, T5, TReturn> method,
				T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5)
		{
			return InvokeInternal<TReturn>(control, method, arg1, arg2, arg3, arg4, arg5);
		}

		/// <summary>
		/// w肵O̗R郁bZ[WƃX^bNg[XA
		/// bZ[W{bNXgĕ\܂B
		/// </summary>
		/// <param name="owner"></param>
		/// <param name="ex"></param>
		[Obsolete("MessageBoxNeo.Error() gĂB")]
		public static void ShowErrorMessage(Control owner, Exception ex)
		{
			ArgumentUtil.AssertNull(owner, "owner");
			ArgumentUtil.AssertNull(ex, "ex");
			Func5<IWin32Window, string, string, MessageBoxButtons, MessageBoxIcon, DialogResult>
					d = MessageBox.Show;
			ControlUtil.InvokeInternal(owner, d, owner,
					ex.ToString(), owner.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
		}

		// internal static \bh //

		/// <summary>
		/// Rg[̊ɂȂEBhE nhLXbhŁA
		/// w肵XggpāAw肵fQ[gs܂B
		/// </summary>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="args"></param>
		internal static object InvokeInternal(Control control, Delegate method, params object[] args)
		{
			ArgumentUtil.AssertNull(control, "control");
			ArgumentUtil.AssertNull(method, "method");
			if (control.InvokeRequired) {
				return control.Invoke(method, args);
			} else {
				return method.Method.Invoke(method.Target, args);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TReturn"></typeparam>
		/// <param name="control"></param>
		/// <param name="method"></param>
		/// <param name="args"></param>
		/// <returns></returns>
		internal static TReturn InvokeInternal<TReturn>(
				Control control, Delegate method, params object[] args)
		{
			ArgumentUtil.AssertNull(control, "control");
			ArgumentUtil.AssertNull(method, "method");
			if (control.InvokeRequired) {
				return (TReturn)control.Invoke(method, args);
			} else {
				return (TReturn)method.Method.Invoke(method.Target, args);
			}
		}
	}
}
