using System;
using System.Collections;
using System.Collections.Generic;
using System.Windows.Forms;

using SystemNeo;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// j[Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class MenuUtil
	{
		// public static \bh //

		/// <summary>
		/// IvV{^gp MenuItem `FbNA
		/// ƕł MenuItem ̃`FbN܂B
		/// </summary>
		/// <param name="menuItem"></param>
		public static void CheckRadioMenuItem(MenuItem menuItem)
		{
			ArgumentUtil.AssertNull(menuItem, "menuItem");
			if (! menuItem.RadioCheck) {
				throw new ArgumentException("MenuItem  RadioCheck  false łB", "menuItem");
			}
			Menu menu = menuItem.Parent;
			if (menu == null) {
				throw new ArgumentException("MenuItem ̐eڂ܂B", "menuItem");
			}
			var items = menu.MenuItems;
			int index = items.IndexOf(menuItem);
			var range = new Int32Range(index, index);
			while (range.MinValue > 0 && items[range.MinValue - 1].RadioCheck) {
				range.MinValue--;
			}
			while (range.MaxValue < items.Count - 1 && items[range.MaxValue + 1].RadioCheck) {
				range.MaxValue++;
			}
			foreach (int i in range) {
				items[i].Checked = (i == index);
			}
		}

		/// <summary>
		/// IvV{^j[ڌQ쐬܂B
		/// </summary>
		/// <param name="parentNode">쐬ꂽj[ڌQ̐eƂȂ郁j[B</param>
		/// <param name="e">j[ڌQ̃LvV񋟂񋓎qB</param>
		/// <param name="checked"></param>
		/// <param name="onClick">j[ڂNbN܂͑IꂽƂɔCxgB</param>
		public static void CreateRadioMenuItems(
				Menu parent, IEnumerable e, object @checked, EventHandler onClick)
		{
			ArgumentUtil.AssertNull(e, "e");
			foreach (object obj in e) {
				var item = new MenuItem(Convert.ToString(obj), onClick) {
					RadioCheck = true,
					Checked = (@checked != null && @checked.Equals(obj)),
					Tag = obj
				};
				if (parent != null) {
					parent.MenuItems.Add(item);
				}
			}
		}

		/// <summary>
		/// IvV{^j[ڌQ쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="parentNode">쐬ꂽj[ڌQ̐eƂȂ郁j[B</param>
		/// <param name="e">j[ڌQ̃LvV񋟂񋓎qB</param>
		/// <param name="checked"></param>
		/// <param name="onClick">j[ڂNbN܂͑IꂽƂɔCxgB</param>
		public static void CreateRadioMenuItems<T>(
				Menu parent, IEnumerable<T> e, T @checked, EventHandler onClick)
		{
			CreateRadioMenuItems(parent, e, @checked, null, onClick);
		}

		/// <summary>
		/// IvV{^j[ڌQ쐬܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="parentNode">쐬ꂽj[ڌQ̐eƂȂ郁j[B</param>
		/// <param name="e">j[ڌQ̃LvV񋟂񋓎qB</param>
		/// <param name="checked"></param>
		/// <param name="textGetter"></param>
		/// <param name="onClick">j[ڂNbN܂͑IꂽƂɔCxgB</param>
		public static void CreateRadioMenuItems<T>(Menu parent, IEnumerable<T> e,
				T @checked, Func<T, string> textGetter, EventHandler onClick)
		{
			ArgumentUtil.AssertNull(e, "e");
			textGetter = textGetter ?? ObjectUtil.ToString;
			foreach (T obj in e) {
				var item = new MenuItem(textGetter(obj), onClick) {
					RadioCheck = true,
					Checked = (@checked != null && @checked.Equals(obj)),
					Tag = obj
				};
				if (parent != null) {
					parent.MenuItems.Add(item);
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public static void ToggleMenuItemCheck(object sender, EventArgs e)
		{
			var mi = (MenuItem)sender;
			mi.Checked = ! mi.Checked;
		}
	}
}
