﻿using System;
using System.Windows.Forms;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// 
	/// </summary>
	public static class MessageBoxNeo
	{
		// public static メソッド //

		/// <summary>
		/// 指定した例外の理由を説明するメッセージとスタックトレースを、
		/// メッセージボックスを使って表示します。
		/// </summary>
		/// <param name="owner"></param>
		/// <param name="ex"></param>
		public static void Error(Control owner, Exception ex)
		{
			Show(owner, ex.ToString(), "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="owner"></param>
		/// <param name="text"></param>
		public static void Info(Control owner, string text)
		{
			Show(owner, text, null, MessageBoxButtons.OK, MessageBoxIcon.Information);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="owner"></param>
		/// <param name="text"></param>
		/// <returns></returns>
		public static bool OKCancel(Control owner, string text)
		{
			return Show(owner, text, null, MessageBoxButtons.OKCancel, MessageBoxIcon.Question)
					== DialogResult.OK;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="owner"></param>
		/// <param name="text"></param>
		/// <returns></returns>
		public static bool YesNo(Control owner, string text)
		{
			return Show(owner, text, null, MessageBoxButtons.YesNo, MessageBoxIcon.Question)
					== DialogResult.Yes;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="owner"></param>
		/// <param name="text"></param>
		public static void Warning(Control owner, string text)
		{
			Show(owner, text, null, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		}

		// private static メソッド //

		private static DialogResult Show(Control owner,
				string text, string caption, MessageBoxButtons buttons, MessageBoxIcon icon)
		{
			ArgumentUtil.AssertNull(owner, "owner");
			ArgumentUtil.AssertNull(text, "text");
			Func5<IWin32Window, string, string, MessageBoxButtons, MessageBoxIcon, DialogResult>
					show = MessageBox.Show;
			return (DialogResult)ControlUtil.InvokeInternal(
					owner, show, owner, text, caption ?? owner.Text, buttons, icon);
		}
	}
}
