using System;
using System.Windows.Forms;

namespace SystemNeo.Windows
{
	/// <summary>
	/// IMalloc C^[tF[XтɂĊmۂ̈bv܂B
	/// </summary>
	internal class Memory : IDisposable
	{
		#region private static fields
		private static readonly IMalloc malloc;
		#endregion

		#region private fields
		private IntPtr memory;
		#endregion

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static Memory()
		{
			Application.OleRequired();
			malloc = NativeMethods.SHGetMalloc();
		}

		// protected RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="memory"></param>
		protected Memory(IntPtr memory)
		{
			if (memory == IntPtr.Zero) {
				throw new ArgumentNullException("memory");
			}
			this.memory = memory;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public void Dispose()
		{
			Free(this.memory);
			this.memory = IntPtr.Zero;
		}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="size"></param>
		/// <returns></returns>
		internal static Memory Allocate(int size)
		{
			return new Memory(AllocateInternal(size));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="size"></param>
		/// <returns></returns>
		internal static IntPtr AllocateInternal(int size)
		{
			if (size <= 0) {
				throw new ArgumentOutOfRangeException("size");
			}
			IntPtr result = malloc.Alloc(size);
			if (result == IntPtr.Zero) {
				throw new OutOfMemoryException();
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="memory"></param>
		internal static void Free(IntPtr memory)
		{
			if (memory != IntPtr.Zero) {
				malloc.Free(memory);
			}
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		internal int GetSize()
		{
			return malloc.GetSize(this.memory);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		internal IntPtr ToIntPtr()
		{
			return this.memory;
		}
	}
}
