using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	internal struct RECT
	{
		// internal tB[h //

		internal int left;
		internal int top;
		internal int right;
		internal int bottom;

		// internal vpeB //

		/// <summary>
		/// 
		/// </summary>
		internal int Height
		{
			get {
				return this.bottom - this.top;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		internal int Width
		{
			get {
				return this.right - this.left;
			}
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <returns></returns>
		public static explicit operator RECT(Rectangle r)
		{
			RECT result;
			result.left = r.Left;
			result.top = r.Top;
			result.right = r.Right;
			result.bottom = r.Bottom;
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <returns></returns>
		public static explicit operator Rectangle(RECT r)
		{
			return new Rectangle(r.left, r.top, r.Width, r.Height);
		}
	}
}
