using System;
using System.IO;
using System.Runtime.InteropServices;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	[Serializable]
	[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
	[BestFitMapping(false)]
	internal struct WIN32_FIND_DATA
	{
		// internal tB[h //

		internal FileAttributes dwFileAttributes;
		internal int ftCreationTime_dwLowDateTime;
		internal int ftCreationTime_dwHighDateTime;
		internal int ftLastAccessTime_dwLowDateTime;
		internal int ftLastAccessTime_dwHighDateTime;
		internal int ftLastWriteTime_dwLowDateTime;
		internal int ftLastWriteTime_dwHighDateTime;
		internal int nFileSizeHigh;
		internal int nFileSizeLow;
		internal int dwReserved0;
		internal int dwReserved1;
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst = FileUtil.PathMaxLength)]
		internal string cFileName;
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 14)]
		internal string cAlternateFileName;

		// internal vpeB //

		/// <summary>
		/// 
		/// </summary>
		internal bool IsDirectory
		{
			get {
				return this.MatchesAttribute(FileAttributes.Directory);
			}
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attribute"></param>
		/// <returns></returns>
		internal bool MatchesAttribute(FileAttributes attribute)
		{
			return ((this.dwFileAttributes & attribute) != 0);
		}
	}
}
