using System;
using System.CodeDom;
using System.CodeDom.Compiler;
using System.Collections.Specialized;
using System.Text;

using SystemNeo.Reflection;

namespace SystemNeo.CodeDom.Compiler
{
	/// <summary>
	/// C# ̃\[XR[hRpCAs܂B
	/// </summary>
	public class CSharpCodeExecutor
	{
		#region private static fields
		private const string TemporaryNamespaceName = "_._._";
		private const string TemporaryClassName = "_";
		#endregion

		#region private fields
		private string source;
		private readonly StringCollection importingNamespaces = new StringCollection();
		private readonly CompilerParameters compilerParameters = new CompilerParameters();
		private CompilerResults compilerResult;
		#endregion

		// private static vpeB //

		/// <summary>
		/// 
		/// </summary>
		private static string TemporaryClassFullName
		{
			get {
				return TemporaryNamespaceName + "." + TemporaryClassName;
			}
		}

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public Type CompiledType
		{
			get {
				return this.compilerResult.CompiledAssembly.GetType(TemporaryClassFullName);
			}
		}

		/// <summary>
		/// C|[g閼OԂ̃RNV擾܂B
		/// </summary>
		public StringCollection ImportingNamespaces
		{
			get {
				return this.importingNamespaces;
			}
		}

		/// <summary>
		/// RpCς݂ǂ擾܂B
		/// </summary>
		public bool IsCompiled
		{
			get {
				return (this.compilerResult != null && this.compilerResult.Errors.Count == 0);
			}
		}

		/// <summary>
		/// RpCюs̍ۂɎQƂAZũRNV擾܂B
		/// </summary>
		public StringCollection ReferencedAssemblies
		{
			get {
				return this.compilerParameters.ReferencedAssemblies;
			}
		}

		/// <summary>
		/// RpC\[XR[h擾܂͐ݒ肵܂B
		/// </summary>
		public string Source
		{
			get {
				return this.source;
			}
			set {
				this.compilerResult = null;
				this.source = value;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public CSharpCodeExecutor()
		{
			this.compilerParameters.GenerateInMemory = true;

			this.importingNamespaces.Add("System");

			StringCollection sc = this.ReferencedAssemblies;
			sc.Add("System.dll");
			sc.Add("System.Data.dll");
			sc.Add("System.Windows.Forms.dll");
			sc.Add("System.Xml.dll");
		}

		// public \bh //

		/// <summary>
		/// RpCς݂łȂꍇ̓RpCsAs܂B
		/// </summary>
		/// <param name="methodName"></param>
		/// <param name="params"></param>
		/// <returns></returns>
		public object Execute(string methodName, params object[] @params)
		{
			if (! this.IsCompiled) {
				this.Compile();
			}
			string className = TemporaryClassFullName;
			object obj = this.compilerResult.CompiledAssembly.CreateInstance(className);
			return new LateBinder(obj).Call(methodName, @params).Eval();
		}

		/// <summary>
		/// RpCs܂B
		/// </summary>
		public void Compile()
		{
			var sb = new StringBuilder();
			foreach (string @namespace in this.importingNamespaces) {
				sb.Append("using ");
				sb.Append(@namespace);
				sb.Append(";\n");
			}

			sb.Append("namespace " + TemporaryNamespaceName + " {\n");
			sb.Append("public class " + TemporaryClassName + " {\n\n");
			sb.Append(this.source);
			sb.Append("\n}\n}");

			this.compilerResult = InternalCompile(sb.ToString());
			if (this.compilerResult.Errors.Count > 0) {
				throw new CompileFailedException(this.compilerResult);
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <returns></returns>
		private CompilerResults InternalCompile(string source)
		{
			var cscp = new Microsoft.CSharp.CSharpCodeProvider();
			return cscp.CompileAssemblyFromSource(this.compilerParameters, source);
		}
	}
}
