using System;
using System.Collections;
using System.Collections.Generic;

using SystemNeo.Reflection;

namespace SystemNeo.Collections.Generic
{
	/// <summary>
	/// L[ƒl̃RNV\܂B
	/// ݂ȂL[ɑ΂ĂAl𐶐ĕԂ܂B
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	/// <typeparam name="TValue"></typeparam>
	public class FactoryDictionary<TKey, TValue> : AbstractDictionary<TKey, TValue>
	{
		#region private fields
		private readonly IDictionary<TKey, TValue> dictionary;
		private readonly Func<TKey, TValue> generator;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override int Count
		{
			get {
				return this.dictionary.Count;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public FactoryDictionary() : this((IDictionary<TKey, TValue>)null, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="generator"></param>
		public FactoryDictionary(Func<TKey, TValue> generator)
				: this(new Dictionary<TKey, TValue>(), generator) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="capacity"></param>
		/// <param name="generator"></param>
		public FactoryDictionary(int capacity, Func<TKey, TValue> generator)
				: this(new Dictionary<TKey, TValue>(capacity), generator) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dictionary"></param>
		/// <param name="generator"></param>
		public FactoryDictionary(
				IDictionary<TKey, TValue> dictionary, Func<TKey, TValue> generator)
				: base(dictionary == null ? false : dictionary.IsReadOnly)
		{
			this.dictionary = dictionary ?? new Dictionary<TKey, TValue>();
			this.generator = generator ?? (value =>
				typeof(TValue).IsValueType ? default(TValue) : TypeUtil.CreateInstance<TValue>());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="comparer"></param>
		public FactoryDictionary(IEqualityComparer<TKey> comparer) : this(comparer, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="capacity"></param>
		/// <param name="comparer"></param>
		public FactoryDictionary(int capacity, IEqualityComparer<TKey> comparer)
				: this(capacity, comparer, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="comparer"></param>
		/// <param name="generator"></param>
		public FactoryDictionary(IEqualityComparer<TKey> comparer, Func<TKey, TValue> generator)
				: this(new Dictionary<TKey, TValue>(comparer), generator) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="capacity"></param>
		/// <param name="comparer"></param>
		/// <param name="generator"></param>
		public FactoryDictionary(
				int capacity, IEqualityComparer<TKey> comparer, Func<TKey, TValue> generator)
				: this(new Dictionary<TKey, TValue>(capacity, comparer), generator) {}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		public override void Add(TKey key, TValue value)
		{
			this.dictionary.Add(key, value);
		}

		/// <summary>
		/// 
		/// </summary>
		public override void Clear()
		{
			this.dictionary.Clear();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public override bool Remove(TKey key)
		{
			return this.dictionary.Remove(key);
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		protected override TValue Get(TKey key)
		{
			if (this.dictionary.ContainsKey(key)) {
				return this.dictionary[key];
			} else {
				TValue value = this.generator(key);
				this.dictionary.Add(key, value);
				return value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected override IEnumerable<KeyValuePair<TKey, TValue>> GetEnumeratorInternal()
		{
			return this.dictionary;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected override ICollection<TKey> GetKeys()
		{
			return this.dictionary.Keys;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		protected override void Set(TKey key, TValue value)
		{
			this.dictionary[key] = value;
		}
	}
}
