using System;
using System.ComponentModel;
using System.Collections;
using System.Data;
using System.IO;

using SystemNeo;
using SystemNeo.Collections;
using SystemNeo.Text;

namespace SystemNeo.Data
{
	/// <summary>
	/// ADO.NET A[LeN`Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class DataUtil
	{
		// public static \bh //

		/// <summary>
		/// w̔zƂ DataTable 쐬܂B
		/// </summary>
		/// <param name="array"></param>
		/// <returns></returns>
		public static DataTable CreateDataTableFrom(Array array)
		{
			return CreateDataTableFrom(array, null);
		}

		/// <summary>
		/// w̔zƂ DataTable 쐬܂B
		/// </summary>
		/// <param name="array"></param>
		/// <param name="propertyNames"></param>
		/// <returns></returns>
		public static DataTable CreateDataTableFrom(Array array, string[] propertyNames)
		{
			ArgumentUtil.AssertNull(array, "array");
			return CreateDataTableFrom(array, array.GetType().GetElementType(), propertyNames);
		}

		/// <summary>
		/// w̃RNVƂ DataTable 쐬܂B
		/// </summary>
		/// <param name="e"></param>
		/// <returns></returns>
		public static DataTable CreateDataTableFrom(IEnumerable e)
		{
			return CreateDataTableFrom(e, null, null);
		}

		/// <summary>
		/// w̃RNVƂ DataTable 쐬܂B
		/// </summary>
		/// <param name="e"></param>
		/// <param name="type"></param>
		/// <returns></returns>
		public static DataTable CreateDataTableFrom(IEnumerable e, Type type)
		{
			return CreateDataTableFrom(e, type, null);
		}

		/// <summary>
		/// w̃RNVƂ DataTable 쐬܂B
		/// </summary>
		/// <param name="e"></param>
		/// <param name='type'>
		/// vpeB擾^Bnull ̏ꍇARNV̐擪̗vf̌^g܂B
		/// </param>
		/// <param name='propertyNames'>
		/// 񋓂vpeB̖OBnull ܂͋̔z̏ꍇASẴvpeB񋓂܂B
		/// </param>
		/// <returns></returns>
		public static DataTable CreateDataTableFrom(
				IEnumerable e, Type type, string[] propertyNames)
		{
			ArgumentUtil.AssertNull(e, "e");
			PropertyDescriptorCollection properties = null;
			DataTable dt = null;
			if (type != null) {
				dt = InternalCreateDataTableFrom(type, out properties, propertyNames);
			}
			foreach (object obj in e) {
				if (properties == null) {
					type = obj.GetType();
					dt = InternalCreateDataTableFrom(type, out properties, propertyNames);
				}
				DataRow row = dt.NewRow();
				foreach (DataColumn column in dt.Columns) {
					object value = properties.Find(column.ColumnName, false).GetValue(obj);
					if (value != null) {
						row[column] = value;
					}
				}
				dt.Rows.Add(row);
			}
			if (dt != null) {
				dt.AcceptChanges();
			}
			return dt;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="columnNames"></param>
		/// <returns></returns>
		public static string CreateDeleteSql(string tableName, ICollection columnNames)
		{
			var converterFormatter = new ConverterFormatter<object, string>(
					columnName => columnName + " = @" + columnName);
			var cf = new CollectionFormatter(converterFormatter, null, null, " AND ");
			var sw = new StringWriter();
			sw.Write("DELETE FROM ");
			sw.Write(tableName);
			sw.Write(" WHERE ");
			cf.WriteTo(sw, columnNames);
			return sw.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="columnNames"></param>
		/// <returns></returns>
		public static string CreateInsertSql(string tableName, ICollection columnNames)
		{
			var sw = new StringWriter();
			sw.Write("INSERT INTO ");
			sw.Write(tableName);
			sw.Write(" (");
			sw.Write(CollectionUtil.Join(columnNames, ", "));
			sw.Write(") VALUES (@");
			sw.Write(CollectionUtil.Join(columnNames, ", @"));
			sw.Write(")");
			return sw.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="columnNames"></param>
		/// <param name="primaryKeyColumnNames"></param>
		/// <returns></returns>
		public static string CreateUpdateSql(
				string tableName, ICollection columnNames, string[] primaryKeyColumnNames)
		{
			var primaryKeys = new ArrayList();
			var notPrimaryKeys = new ArrayList();
			foreach (string columnName in columnNames) {
				string s = columnName + " = @" + columnName;
				if (Array.IndexOf(primaryKeyColumnNames, columnName) >= 0) {
					primaryKeys.Add(s);
				} else {
					notPrimaryKeys.Add(s);
				}
			}

			var sw = new StringWriter();
			sw.Write("UPDATE ");
			sw.Write(tableName);
			sw.Write(" SET ");
			sw.Write(CollectionUtil.Join(notPrimaryKeys, ", "));
			sw.Write(" WHERE ");
			sw.Write(CollectionUtil.Join(primaryKeys, " AND "));
			return sw.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="row"></param>
		/// <returns></returns>
		public static IDictionary DataRowToDictionary(DataRow row)
		{
			ArgumentUtil.AssertNull(row, "row");
			var result = new Hashtable();
			foreach (DataColumn column in row.Table.Columns) {
				result[column.ColumnName] = row[column];
			}
			return result;
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <param name="properties"></param>
		/// <param name="propertyNames"></param>
		/// <returns></returns>
		private static DataTable InternalCreateDataTableFrom(
				Type type, out PropertyDescriptorCollection properties, string [] propertyNames)
		{
			properties = TypeDescriptor.GetProperties(type);
			var dt = new DataTable(type.FullName);
			AddDataColumns(dt.Columns, properties, propertyNames);
			return dt;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="columns"></param>
		/// <param name="properties"></param>
		private static void AddDataColumns(
				DataColumnCollection columns, PropertyDescriptorCollection properties)
		{
			foreach (PropertyDescriptor property in properties) {
				columns.Add(property.Name, property.PropertyType);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="columns"></param>
		/// <param name="properties"></param>
		/// <param name="propertyNames"></param>
		private static void AddDataColumns(DataColumnCollection columns,
				PropertyDescriptorCollection properties, string[] propertyNames)
		{
			if (propertyNames == null || propertyNames.Length == 0) {
				AddDataColumns(columns, properties);
				return;
			}
			foreach (string name in propertyNames) {
				var property = properties.Find(name, false);
				columns.Add(name, property.PropertyType);
			}
		}
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                