using System;
using System.Diagnostics;

using SystemNeo;

namespace SystemNeo.Diagnostics
{
	/// <summary>
	/// 
	/// </summary>
	public class PerformanceCounterCache
	{
		#region private fields
		private DateTime lastDate;
		private float lastValue;
		private TimeSpan lifeTime = TimeSpan.FromSeconds(1.0);
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public PerformanceCounter Counter { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public TimeSpan LifeTime
		{
			get {
				return this.lifeTime;
			}
			set {
				this.lifeTime = value;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public PerformanceCounterCache() : this(new PerformanceCounter()) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="counter"></param>
		public PerformanceCounterCache(PerformanceCounter counter)
		{
			ArgumentUtil.AssertNull(counter, "counter");
			this.Counter = counter;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="categoryName"></param>
		/// <param name="counterName"></param>
		public PerformanceCounterCache(string categoryName, string counterName)
				: this(new PerformanceCounter(categoryName, counterName)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="categoryName"></param>
		/// <param name="counterName"></param>
		/// <param name="readOnly"></param>
		public PerformanceCounterCache(string categoryName, string counterName, bool readOnly)
				: this(new PerformanceCounter(categoryName, counterName, readOnly)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="categoryName"></param>
		/// <param name="counterName"></param>
		/// <param name="instanceName"></param>
		public PerformanceCounterCache(string categoryName, string counterName, string instanceName)
				: this(new PerformanceCounter(categoryName, counterName, instanceName)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="categoryName"></param>
		/// <param name="counterName"></param>
		/// <param name="instanceName"></param>
		/// <param name="readOnly"></param>
		public PerformanceCounterCache(
				string categoryName, string counterName, string instanceName, bool readOnly)
				: this(new PerformanceCounter(
						categoryName, counterName, instanceName, readOnly)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="categoryName"></param>
		/// <param name="counterName"></param>
		/// <param name="instanceName"></param>
		/// <param name="machineName"></param>
		public PerformanceCounterCache(
				string categoryName, string counterName, string instanceName, string machineName)
				: this(new PerformanceCounter(
						categoryName, counterName, instanceName, machineName)) {}

		// public \bh //
		
		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public float NextValue()
		{
			DateTime now = DateTime.Now;
			lock (this) {
				if (now - this.lastDate > this.lifeTime) {
					this.lastValue = this.Counter.NextValue();
					this.lastDate = now;
				}
				return this.lastValue;
			}
		}
	}
}
