using System;
using System.Drawing;
using System.Drawing.Imaging;

using SystemNeo;

namespace SystemNeo.Drawing
{
	/// <summary>
	/// GDI+ ̃OtBbNX@\Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class GraphicsUtil
	{
		// public static \bh //

		/// <summary>
		/// `悷IuWFNg̃TCYw肳ꂽTCYɎ߂邽߂̔{߂܂B
		/// </summary>
		/// <param name="objectSize">`悷IuWFNg̃TCYB</param>
		/// <param name="areaSize">`̗̈̃TCYB</param>
		/// <returns>`悷{B</returns>
		public static double AdjustSizeInArea(Size objectSize, Size areaSize)
		{
			double w = (double)objectSize.Width / areaSize.Width;
			double h = (double)objectSize.Height / areaSize.Height;
			double max = Math.Max(w, h);
			double result = (max <= 1.0 ? 1.0 : 1.0 / max);
			if (Math.Ceiling(result * objectSize.Width) > areaSize.Width) {
				result -= 0.005;
			}
			if (Math.Ceiling(result * objectSize.Height) > areaSize.Height) {
				result -= 0.005;
			}
			return result;
		}

		/// <summary>
		/// Obh`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="pitchX">Obh X ̊ԊuB</param>
		/// <param name="pitchY">Obh Y ̊ԊuB</param>
		/// <param name="rectangle">Obh`悷̈B</param>
		/// <param name="color">̐FB</param>
		public static void DrawGrid(
				Graphics graphics, int pitchX, int pitchY, Rectangle rectangle, Color color)
		{
			DrawGrid(graphics, pitchX, pitchY, rectangle, color, 1.0f, 1.0f);
		}

		/// <summary>
		/// Obh`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="pitchX">Obh X ̊ԊuB</param>
		/// <param name="pitchY">Obh Y ̊ԊuB</param>
		/// <param name="rectangle">Obh`悷̈B</param>
		/// <param name="color">̐FB</param>
		/// <param name="width">̕B</param>
		public static void DrawGrid(Graphics graphics,
				int pitchX, int pitchY, Rectangle rectangle, Color color, float width)
		{
			DrawGrid(graphics, pitchX, pitchY, rectangle, color, width, 1.0f);
		}

		/// <summary>
		/// Obh`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="pitchX">Obh X ̊ԊuB</param>
		/// <param name="pitchY">Obh Y ̊ԊuB</param>
		/// <param name="rectangle">Obh`悷̈B</param>
		/// <param name="color">̐FB</param>
		/// <param name="width">̕B</param>
		/// <param name="zoomRatio"></param>
		public static void DrawGrid(Graphics graphics, int pitchX,
				int pitchY, Rectangle rectangle, Color color, float width, float zoomRatio)
		{
			ArgumentUtil.AssertNull(graphics, "graphics");
			if (pitchX <= 0) {
				throw new ArgumentOutOfRangeException("pitchX");
			}
			if (pitchY <= 0) {
				throw new ArgumentOutOfRangeException("pitchY");
			}
			if (width <= 0) {
				throw new ArgumentOutOfRangeException("width");
			}
			if (zoomRatio <= 0) {
				throw new ArgumentOutOfRangeException("zoomRatio");
			}
			var pen = new Pen(color, width);
			int x = 0;
			float fx;
			do {
				x += pitchX;
				fx = x * zoomRatio;
				graphics.DrawLine(pen, fx, rectangle.Top, fx, rectangle.Bottom);
			} while (fx < rectangle.Right);
			int y = 0;
			float fy;
			do {
				y += pitchY;
				fy = y * zoomRatio;
				graphics.DrawLine(pen, rectangle.Left, fy, rectangle.Right, fy);
			} while (fy < rectangle.Bottom);
		}

		/// <summary>
		/// w肵ʒuɁAw肵C[W̃sNZTCYŕ`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="point">`悷C[W̍[̈ʒuB</param>
		/// <param name="image"></param>
		public static void DrawImage(Graphics graphics,
				Rectangle clipRectangle, ScalingMode mode, Point point, Image image)
		{
			DrawImage(graphics, clipRectangle, mode, point.X, point.Y, image, null);
		}

		/// <summary>
		/// w肵ʒuɁAw肵C[W̃sNZTCYŕ`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="point">`悷C[W̍[̈ʒuB</param>
		/// <param name="image"></param>
		/// <param name="imageAttr"></param>
		public static void DrawImage(Graphics graphics, Rectangle clipRectangle,
				ScalingMode mode, Point point, Image image, ImageAttributes imageAttr)
		{
			DrawImage(graphics, clipRectangle, mode, point.X, point.Y, image, imageAttr);
		}

		/// <summary>
		/// w肵ʒuɎw肵C[W`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="x">`悷C[W̍[ x WB</param>
		/// <param name="y">`悷C[W̏[ y WB</param>
		/// <param name="image"></param>
		public static void DrawImage(Graphics graphics,
				Rectangle clipRectangle, ScalingMode mode, int x, int y, Image image)
		{
			DrawImage(graphics, clipRectangle, mode, x, y, image, null);
		}

		/// <summary>
		/// w肵ʒuɎw肵C[W`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="x">`悷C[W̍[ x WB</param>
		/// <param name="y">`悷C[W̏[ y WB</param>
		/// <param name="image"></param>
		/// <param name="imageAttr"></param>
		public static void DrawImage(Graphics graphics, Rectangle clipRectangle,
				ScalingMode mode, int x, int y, Image image, ImageAttributes imageAttr)
		{
			ArgumentUtil.AssertNull(graphics, "graphics");
			switch (mode) {
			case ScalingMode.KeepPixelSize:
				break;
			default:
				throw new NotSupportedException();
			}
			if (image != null) {
				Rectangle destRect = Rectangle.Intersect(
						clipRectangle, new Rectangle(x, y, image.Width, image.Height));
				if (! destRect.IsEmpty) {
					graphics.DrawImage(image, destRect, destRect.Left - x, destRect.Top - y,
							destRect.Width, destRect.Height, GraphicsUnit.Pixel, imageAttr);
				}
			}
		}

		/// <summary>
		/// et̕`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="s"></param>
		/// <param name="font"></param>
		/// <param name="color"></param>
		/// <param name="point"></param>
		/// <param name="shadowColor"></param>
		/// <param name="shadowOffset"></param>
		public static void DrawShadowedString(Graphics graphics, string s,
				Font font, Color color, PointF point, Color shadowColor, SizeF shadowOffset)
		{
			DrawShadowedString(graphics, s, font,
					new SolidBrush(color), point.X, point.Y, new SolidBrush(shadowColor),
					shadowOffset.Width, shadowOffset.Height, StringFormat.GenericDefault);
		}

		/// <summary>
		/// et̕`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="s"></param>
		/// <param name="font"></param>
		/// <param name="color"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="shadowColor"></param>
		/// <param name="shadowOffsetX"></param>
		/// <param name="shadowOffsetY"></param>
		public static void DrawShadowedString(Graphics graphics, string s, Font font, Color color,
				float x, float y, Color shadowColor, float shadowOffsetX, float shadowOffsetY)
		{
			DrawShadowedString(graphics,
					s, font, new SolidBrush(color), x, y, new SolidBrush(shadowColor),
					shadowOffsetX, shadowOffsetY, StringFormat.GenericDefault);
		}

		/// <summary>
		/// et̕`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="s"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="point"></param>
		/// <param name="shadowBrush"></param>
		/// <param name="shadowOffset"></param>
		/// <param name="format"></param>
		public static void DrawShadowedString(Graphics graphics, string s, Font font, Brush brush,
				PointF point, Brush shadowBrush, SizeF shadowOffset, StringFormat format)
		{
			DrawShadowedString(graphics, s, font, brush,
					point.X, point.Y, shadowBrush, shadowOffset.Width, shadowOffset.Height, format);
		}

		/// <summary>
		/// et̕`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="s"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="shadowBrush"></param>
		/// <param name="shadowOffsetX"></param>
		/// <param name="shadowOffsetY"></param>
		/// <param name="format"></param>
		public static void DrawShadowedString(Graphics graphics,
				string s, Font font, Brush brush, float x, float y,
				Brush shadowBrush, float shadowOffsetX, float shadowOffsetY, StringFormat format)
		{
			ArgumentUtil.AssertNull(graphics, "graphics");
			if (s != null && s != string.Empty) {
				graphics.DrawString(
						s, font, shadowBrush, x + shadowOffsetX, y + shadowOffsetY, format);
				graphics.DrawString(s, font, brush, x, y, format);
			}
		}

		/// <summary>
		/// C[W^Cɕׂĕ`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="point"></param>
		/// <param name="image"></param>
		/// <param name="repeatX"></param>
		/// <param name="repeatY"></param>
		public static void DrawTileImage(Graphics graphics, Rectangle clipRectangle,
				ScalingMode mode, Point point, Image image, bool repeatX, bool repeatY)
		{
			DrawTileImage(graphics,
					clipRectangle, mode, point.X, point.Y, image, null, repeatX, repeatY);
		}

		/// <summary>
		/// C[W^Cɕׂĕ`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="point"></param>
		/// <param name="image"></param>
		/// <param name="imageAttr"></param>
		/// <param name="repeatX"></param>
		/// <param name="repeatY"></param>
		public static void DrawTileImage(
				Graphics graphics, Rectangle clipRectangle, ScalingMode mode,
				Point point, Image image, ImageAttributes imageAttr, bool repeatX, bool repeatY)
		{
			DrawTileImage(graphics,
					clipRectangle, mode, point.X, point.Y, image, imageAttr, repeatX, repeatY);
		}

		/// <summary>
		/// C[W^Cɕׂĕ`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="image"></param>
		/// <param name="repeatX"></param>
		/// <param name="repeatY"></param>
		public static void DrawTileImage(Graphics graphics, Rectangle clipRectangle,
				ScalingMode mode, int x, int y, Image image, bool repeatX, bool repeatY)
		{
			DrawTileImage(graphics, clipRectangle, mode, x, y, image, null, repeatX, repeatY);
		}

		/// <summary>
		/// C[W^Cɕׂĕ`悵܂B
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="image"></param>
		/// <param name="imageAttr"></param>
		/// <param name="repeatX"></param>
		/// <param name="repeatY"></param>
		public static void DrawTileImage(
				Graphics graphics, Rectangle clipRectangle, ScalingMode mode,
				int x, int y, Image image, ImageAttributes imageAttr, bool repeatX, bool repeatY)
		{
			ArgumentUtil.AssertNull(graphics, "graphics");
			switch (mode) {
			case ScalingMode.KeepPixelSize:
				break;
			default:
				throw new NotSupportedException();
			}
			DrawTileImageInternal(graphics,
					clipRectangle, mode, x, y, image, imageAttr, repeatX, repeatY);
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="image"></param>
		/// <param name="imageAttr"></param>
		/// <param name="repeatX"></param>
		/// <param name="repeatY"></param>
		private static void DrawTileImageInternal(
				Graphics graphics, Rectangle clipRectangle, ScalingMode mode,
				int x, int y, Image image, ImageAttributes imageAttr, bool repeatX, bool repeatY)
		{
			if (repeatX) {
				DrawTileImageX(graphics, clipRectangle, mode, x, y, image, imageAttr, repeatY);
			} else if (repeatY) {
				DrawTileImageY(graphics, clipRectangle, mode, x, y, image, imageAttr, repeatX);
			} else {
				DrawImage(graphics, clipRectangle, mode, x, y, image, imageAttr);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="image"></param>
		/// <param name="imageAttr"></param>
		/// <param name="repeatY"></param>
		private static void DrawTileImageX(
				Graphics graphics, Rectangle clipRectangle, ScalingMode mode,
				int x, int y, Image image, ImageAttributes imageAttr, bool repeatY)
		{
			int width = image.Width;
			int ax = x;
			while (ax > clipRectangle.Left) {
				ax -= width;
			}
			do {
				if (ax + width >= clipRectangle.Left) {
					DrawTileImageInternal(
							graphics, clipRectangle, mode, ax, y, image, imageAttr, false, repeatY);
				}
				ax += width;
			} while (ax < clipRectangle.Right);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="graphics"></param>
		/// <param name="clipRectangle"></param>
		/// <param name="mode"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="image"></param>
		/// <param name="imageAttr"></param>
		/// <param name="repeatX"></param>
		private static void DrawTileImageY(
				Graphics graphics, Rectangle clipRectangle, ScalingMode mode,
				int x, int y, Image image, ImageAttributes imageAttr, bool repeatX)
		{
			int height = image.Height;
			int ay = y;
			while (ay > clipRectangle.Top) {
				ay -= height;
			}
			do {
				if (ay + height >= clipRectangle.Top) {
					DrawTileImageInternal(
							graphics, clipRectangle, mode, x, ay, image, imageAttr, repeatX, false);
				}
				ay += height;
			} while (ay < clipRectangle.Bottom);
		}
	}
}
