using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;

using SystemNeo;

namespace SystemNeo.Drawing
{
	/// <summary>
	/// C[WɊւ郁\bh񋟂܂B
	/// </summary>
	public static class ImageUtil
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="mimeType"></param>
		/// <returns></returns>
		public static ImageCodecInfo GetEncoderInfo(string mimeType)
		{
			ArgumentUtil.AssertNull(mimeType, "mimeType");
			ImageCodecInfo[] encoders = ImageCodecInfo.GetImageEncoders();
			foreach (var encoder in encoders) {
				if (encoder.MimeType == mimeType) {
					return encoder;
				}
			}
			return null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="stream"></param>
		/// <returns></returns>
		public static Image TryLoadImage(Stream stream)
		{
			Exception ex;
			return TryLoadImage(stream, out ex);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="stream"></param>
		/// <param name="exception"></param>
		/// <returns></returns>
		public static Image TryLoadImage(Stream stream, out Exception exception)
		{
			ArgumentUtil.AssertNull(stream, "stream");
			exception = null;
			try {
				return Image.FromStream(stream);
			} catch (Exception ex) {
				exception = ex;
				return null;
			}
		}
	}
}
