using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

using SystemNeo;
using SystemNeo.Collections;
using SystemNeo.Text;

namespace SystemNeo.IO
{
	/// <summary>
	/// v~eBu f[^^oCilƂēǂݎ܂B
	/// <see cref="System.IO.BinaryReader">BinaryReader</see> ̑Ɏgpł܂B
	/// </summary>
	public class BinaryReaderNeo : BinaryReader
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public static readonly Encoding DefaultEncoding = Encoding.UTF8;

		#region private fields
		private ByteOrder byteOrder;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public ByteOrder ByteOrder
		{
			get {
				return this.byteOrder;
			}
			set {
				ArgumentUtil.AssertInvalidEnum(value, "ByteOrder");
				this.byteOrder = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Encoding Encoding { get; private set; }

		/// <summary>
		/// [_[Xg[̖ɔzuĂ邩ǂl擾܂B
		/// </summary>
		public bool EOF
		{
			get {
				return this.Position >= this.Length;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public long Length
		{
			get {
				return this.BaseStream.Length;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public long Position
		{
			get {
				return this.BaseStream.Position;
			}
			set {
				this.BaseStream.Position = value;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="buffer"></param>
		public BinaryReaderNeo(byte[] buffer) : this(new MemoryStream(buffer)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="input"></param>
		public BinaryReaderNeo(Stream input)
				: this(input, ByteOrder.LittleEndian, DefaultEncoding) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="buffer"></param>
		/// <param name="byteOrder"></param>
		public BinaryReaderNeo(byte[] buffer, ByteOrder byteOrder)
				: this(new MemoryStream(buffer), byteOrder) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="input"></param>
		/// <param name="byteOrder"></param>
		public BinaryReaderNeo(Stream input, ByteOrder byteOrder)
				: this(input, byteOrder, DefaultEncoding) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="buffer"></param>
		/// <param name="byteOrder"></param>
		/// <param name="encoding"></param>
		public BinaryReaderNeo(byte[] buffer, ByteOrder byteOrder, Encoding encoding)
				: this(new MemoryStream(buffer), byteOrder, encoding) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="input"></param>
		/// <param name="byteOrder"></param>
		public BinaryReaderNeo(Stream input, ByteOrder byteOrder, Encoding encoding)
				: base(input, encoding)
		{
			ArgumentUtil.AssertInvalidEnum(byteOrder, "byteOrder");
			this.byteOrder = byteOrder;
			this.Encoding = encoding;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public IDisposable KeepPosition()
		{
			return new PositionKeeper(this);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public byte PeekByte()
		{
			using (new PositionKeeper(this)) {
				return this.ReadByte();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="count"></param>
		/// <returns></returns>
		public byte[] PeekBytes(int count)
		{
			using (new PositionKeeper(this)) {
				return this.ReadBytes(count);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="count"></param>
		/// <returns></returns>
		public char[] PeekChars(int count)
		{
			if (! this.BaseStream.CanSeek) {
				return null;
			}
			using (new PositionKeeper(this)) {
				return this.ReadChars(count);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="terminator"></param>
		/// <returns></returns>
		public char[] PeekChars(char terminator)
		{
			if (! this.BaseStream.CanSeek) {
				return null;
			}
			using (new PositionKeeper(this)) {
				return this.ReadChars(terminator);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public int PeekInt32()
		{
			using (new PositionKeeper(this)) {
				return this.ReadInt32();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public uint PeekUInt32()
		{
			using (new PositionKeeper(this)) {
				return this.ReadUInt32();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="count"></param>
		/// <returns></returns>
		public string PeekString(int count)
		{
			using (new PositionKeeper(this)) {
				return this.ReadString(count);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="terminator"></param>
		/// <returns></returns>
		public string PeekString(char terminator)
		{
			using (new PositionKeeper(this)) {
				return this.ReadString(terminator);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public byte[] PeekToEnd()
		{
			using (new PositionKeeper(this)) {
				return this.ReadToEnd();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public string PeekToEndAsString()
		{
			using (new PositionKeeper(this)) {
				return this.ReadToEndAsString();
			}
		}

		/// <summary>
		/// w肳ꂽ܂ł̊ԁAǂݎAzƂĕԂ܂B
		/// </summary>
		/// <param name="terminator"></param>
		/// <returns></returns>
		public char[] ReadChars(char terminator)
		{
			var list = new List<char>();
			var cfo = new CharFilterProvider(true, terminator);
			ReadCharsInternal(cfo.Accept, list);
			return list.ToArray();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override decimal ReadDecimal()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadDecimal();
			}
			throw new NotImplementedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override double ReadDouble()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadDouble();
			} else {
				BinaryReader reader = this.CreateReverseReader(sizeof(double));
				return reader.ReadDouble();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override short ReadInt16()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadInt16();
			}
			short result = 0;
			foreach (byte b in this.ReadBytesMust(sizeof(short))) {
				result <<= 8;
				result |= (short)b;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override int ReadInt32()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadInt32();
			}
			int result = 0;
			foreach (byte b in this.ReadBytesMust(sizeof(int))) {
				result <<= 8;
				result |= (int)b;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override long ReadInt64()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadInt64();
			}
			long result = 0;
			foreach (byte b in this.ReadBytesMust(sizeof(long))) {
				result <<= 8;
				result |= (long)b;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override float ReadSingle()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadSingle();
			} else {
				BinaryReader reader = this.CreateReverseReader(sizeof(float));
				return reader.ReadSingle();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="count"></param>
		/// <returns></returns>
		public string ReadString(int count)
		{
			return new string(this.ReadChars(count));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="terminator"></param>
		/// <returns></returns>
		public string ReadString(char terminator)
		{
			return new string(this.ReadChars(terminator));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public byte[] ReadToEnd()
		{
			long count = this.BaseStream.Length - this.BaseStream.Position;
			return this.ReadBytes((int)count);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public string ReadToEndAsString()
		{
			return this.Encoding.GetString(this.ReadToEnd());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override ushort ReadUInt16()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadUInt16();
			}
			ushort result = 0;
			foreach (byte b in this.ReadBytesMust(sizeof(ushort))) {
				result <<= 8;
				result |= b;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="count"></param>
		/// <returns></returns>
		public ushort[] ReadUInt16s(int count)
		{
			ushort[] result = new ushort[count];
			for (int i = 0; i < count; i++) {
				result[i] = this.ReadUInt16();
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override uint ReadUInt32()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadUInt32();
			}
			uint result = 0;
			foreach (byte b in this.ReadBytesMust(sizeof(uint))) {
				result <<= 8;
				result |= b;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override ulong ReadUInt64()
		{
			if (this.byteOrder == ByteOrder.LittleEndian) {
				return base.ReadUInt64();
			}
			ulong result = 0;
			foreach (byte b in this.ReadBytesMust(sizeof(ulong))) {
				result <<= 8;
				result |= b;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="offset"></param>
		/// <returns></returns>
		public long Seek(long offset)
		{
			return this.Seek(offset, SeekOrigin.Current);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="offset"></param>
		/// <param name="origin"></param>
		/// <returns></returns>
		public long Seek(long offset, SeekOrigin origin)
		{
			return this.BaseStream.Seek(offset, origin);
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		internal void AssertCanSeek()
		{
			if (! this.BaseStream.CanSeek) {
				throw new NotSupportedException("Xg[V[NT|[gĂ܂B");
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="count"></param>
		/// <returns></returns>
		private BinaryReader CreateReverseReader(int count)
		{
			byte[] bytes = this.ReadBytes(count);
			Array.Reverse(bytes);
			return new BinaryReader(new MemoryStream(bytes));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="count"></param>
		/// <returns></returns>
		private byte[] ReadBytesMust(int count)
		{
			byte[] result = this.ReadBytes(count);
			if (result.Length < count) {
				throw new EndOfStreamException();
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="continueFilter"></param>
		/// <param name="result"></param>
		private void ReadCharsInternal(Predicate<char> continueFilter, IList<char> result)
		{
			try {
				char c;
				do {
					c = this.ReadChar();
					result.Add(c);
				} while (continueFilter(c));
			} catch (EndOfStreamException) {
			}
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		private sealed class PositionKeeper : IDisposable
		{
			#region private fields
			private readonly BinaryReaderNeo reader;
			private readonly long position;
			#endregion

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="reader"></param>
			internal PositionKeeper(BinaryReaderNeo reader)
			{
				reader.AssertCanSeek();
				this.reader = reader;
				this.position = reader.BaseStream.Position;
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			void IDisposable.Dispose()
			{
				this.reader.BaseStream.Position = this.position;
			}
		}
	}
}
