using System;
using System.ComponentModel;
using System.IO;

using SystemNeo;

namespace SystemNeo.IO
{
	/// <summary>
	/// t@Cp̃Xg[擾@\񋟂܂B
	/// </summary>
	public class FileStreamProvider : IStreamProvider
	{
		#region private fields
		private string path;
		private FileMode mode;
		private FileAccess access;
		private FileShare share;
		private int bufferSize = StreamUtil.DefaultBufferSize;
		private Stream stream;
		private FileOptions options = FileOptions.None;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string Path { get; set; }

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(FileMode.Open)]
		public FileMode Mode
		{
			get {
				return this.mode;
			}
			set {
				this.mode = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(FileAccess.Read)]
		public FileAccess Access
		{
			get {
				return this.access;
			}
			set {
				this.access = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(FileShare.Read)]
		public FileShare Share
		{
			get {
				return this.share;
			}
			set {
				this.share = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(StreamUtil.DefaultBufferSize)]
		public int BufferSize
		{
			get {
				return this.bufferSize;
			}
			set {
				this.bufferSize = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(FileOptions.None)]
		public FileOptions Options {
			get {
				return this.options;
			}
			set {
				this.options = value;
			}
		}

		// RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="path"></param>
		public FileStreamProvider(string path)
				: this(path, FileMode.Open, FileAccess.Read, FileShare.Read) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="path"></param>
		/// <param name="mode"></param>
		/// <param name="access"></param>
		public FileStreamProvider(string path, FileMode mode, FileAccess access)
				: this(path, mode, access, FileShare.Read) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="path"></param>
		/// <param name="mode"></param>
		/// <param name="access"></param>
		/// <param name="share"></param>
		public FileStreamProvider(string path, FileMode mode, FileAccess access, FileShare share)
				: this(path, mode, access, share, StreamUtil.DefaultBufferSize) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="path"></param>
		/// <param name="mode"></param>
		/// <param name="access"></param>
		/// <param name="share"></param>
		/// <param name="bufferSize"></param>
		public FileStreamProvider(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize)
		{
			ArgumentUtil.AssertNull(path, "path");
			this.path = path;
			this.mode = mode;
			this.access = access;
			this.share = share;
			this.bufferSize = bufferSize;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="path"></param>
		/// <param name="mode"></param>
		/// <param name="access"></param>
		/// <param name="share"></param>
		/// <param name="options"></param>
		public FileStreamProvider(string path,
				FileMode mode, FileAccess access, FileShare share, FileOptions options)
			: this(path, mode, access, share)
		{
			this.options = options;
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		void IDisposable.Dispose()
		{
			this.stream.Close();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		Stream IStreamProvider.GetStream()
		{
			this.stream = new FileStream(
					this.path, this.mode, this.access, this.share, this.bufferSize, this.options);
			return this.stream;
		}
	}
}
