﻿using System;
using System.IO;

namespace SystemNeo.IO
{
	/// <summary>
	/// 
	/// </summary>
	public static class FileSystemUtil
	{
		/// <summary>
		/// 
		/// </summary>
		/// <param name="file"></param>
		/// <param name="directory"></param>
		/// <param name="ignoreContentsOfSubdirectory"></param>
		/// <returns></returns>
		public static bool IsInDirectory(this FileSystemInfo file, DirectoryInfo directory, bool ignoreContentsOfSubdirectory)
		{
			string path = file.FullName;
			for (;;) {
				path = Path.GetDirectoryName(path);
				if (path == null) {
					return false;
				}
				if (path == directory.FullName) {
					return true;
				}
				if (ignoreContentsOfSubdirectory) {
					return false;
				}
			}
		}
	}
}
