﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;

using SystemNeo.Text.RegularExpressions;

namespace SystemNeo.IO
{
	public class InitializeFileReader : IDisposable
	{
		#region private static fields
		private static readonly Regex reSectionHeader = new Regex(@"^\[(?<name>[^\]]+)\]");
		private static readonly Regex reKeyValue = new Regex(@"^(?<key>[^=;]+)=(?<value>.*)");
		#endregion

		#region private fields
		private readonly TextReader reader;
		private readonly IDictionary<string, IDictionary<string, string>> dic
				= new Dictionary<string, IDictionary<string, string>>();
		private IDictionary<string, string> currentSectionDic;
		#endregion

		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sectionName"></param>
		/// <param name="keyName"></param>
		/// <returns></returns>
		public string this[string sectionName, string keyName]
		{
			get {
				return this[sectionName, keyName, string.Empty];
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sectionName"></param>
		/// <param name="keyName"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public string this[string sectionName, string keyName, string defaultValue]
		{
			get {
				try {
					return this.dic[sectionName][keyName];
				} catch (KeyNotFoundException) {
					return defaultValue;
				}
			}
		}

		// public コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="path"></param>
		public InitializeFileReader(string path)
		{
			this.reader = new StreamReader(path, Encoding.Default);
			this.ReadToEnd();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="file"></param>
		public InitializeFileReader(FileInfo file) : this(file.FullName) { }

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		public void Close()
		{
			this.reader.Close();
		}

		/// <summary>
		/// 
		/// </summary>
		public void Dispose()
		{
			this.reader.Dispose();
		}

		// private メソッド //

		private void ReadToEnd()
		{
			for (;;) {
				string line = this.reader.ReadLine();
				if (line == null) {
					break;
				}
				// セクションヘッダ
				GroupDictionary gd = GetGroupDictionary(line, reSectionHeader);
				if (gd != null) {
					this.currentSectionDic = new Dictionary<string, string>();
					this.dic[gd["name"]] = this.currentSectionDic;
					continue;
				}
				// 一般行
				gd = GetGroupDictionary(line, reKeyValue);
				if (gd != null && this.currentSectionDic != null) {
					this.currentSectionDic[gd["key"]] = gd["value"];
				}
			}
		}

		private static GroupDictionary GetGroupDictionary(string input, Regex regex)
		{
			Match m = regex.Match(input);
			if (m.Success) {
				return new GroupDictionary(regex, m.Groups);
			} else {
				return null;
			}
		}
	}
}
