using System;
using System.IO;

using SystemNeo;

namespace SystemNeo.IO
{
	/// <summary>
	/// ʂ̃Xg[͈̂͂ɂԐړIɃANZXXg[łB
	/// </summary>
	public class PartialStream : WrapperStream
	{
		#region private fields
		private readonly long beginOffset;
		private readonly long endOffset;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override long Length
		{
			get {
				return this.endOffset - this.beginOffset;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override long Position
		{
			get {
				return base.Position - this.beginOffset;
			}
			set {
				if (value < 0) {
					throw new ArgumentOutOfRangeException("Position", "0ȏłȂ΂Ȃ܂B");
				}
				base.Position = value + this.beginOffset;
			}
		}

		// protected vpeB //

		/// <summary>
		/// Xg[݈̌ʒu疖܂ł̒擾܂B
		/// </summary>
		protected long LeftLength
		{
			get {
				return Math.Max(0, this.endOffset - this.stream.Position);
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="stream"></param>
		public PartialStream(Stream stream) : base(stream)
		{
			this.beginOffset = stream.Position;
			this.endOffset = stream.Length;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="stream"></param>
		/// <param name="beginOffset"></param>
		/// <param name="endOffset"></param>
		public PartialStream(Stream stream, long beginOffset, long endOffset) : base(stream)
		{
			if (beginOffset < 0) {
				throw new ArgumentOutOfRangeException("beginOffset", "0ȏłȂ΂Ȃ܂B");
			}
			if (endOffset < beginOffset) {
				throw new ArgumentException("endOffset  beginOffset ȏłȂ΂Ȃ܂B");
			}
			this.beginOffset = beginOffset;
			this.endOffset = endOffset;
			this.stream.Position = beginOffset;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="buffer"></param>
		/// <param name="offset"></param>
		/// <param name="count"></param>
		/// <returns></returns>
		public override int Read(byte[] buffer, int offset, int count)
		{
			AssertArgumentBufferOffsetCount(buffer, offset, count);
			long leftLength = this.LeftLength;
			if (leftLength <= 0) {
				return 0;
			}
			int readCount = (int)Math.Min(count, leftLength);
			return this.stream.Read(buffer, offset, readCount);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="offset"></param>
		/// <param name="origin"></param>
		/// <returns></returns>
		public override long Seek(long offset, SeekOrigin origin)
		{
			ArgumentUtil.AssertInvalidEnum(origin, "origin");
			switch (origin) {
			case SeekOrigin.Begin:
				if (offset < 0) {
					throw new ArgumentOutOfRangeException(
							"offset", "0ȏłȂ΂Ȃ܂B");
				}
				this.Position = offset;
				break;
			case SeekOrigin.Current:
				if (offset < - this.Position) {
					throw new ArgumentOutOfRangeException(
							"offset", "0ʒuOւ̓V[Nł܂B");
				}
				this.Position += offset;
				break;
			case SeekOrigin.End:
				long newPosition = this.Length + offset;
				if (newPosition < 0) {
					throw new ArgumentOutOfRangeException(
							"offset", "0ʒuOւ̓V[Nł܂B");
				}
				this.Position = newPosition;
				break;
			}
			return this.Position;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		public override void SetLength(long value)
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="buffer"></param>
		/// <param name="offset"></param>
		/// <param name="count"></param>
		public override void Write(byte[] buffer, int offset, int count)
		{
			AssertArgumentBufferOffsetCount(buffer, offset, count);
			if (this.LeftLength < count) {
				throw new IOException("Xg[̖z邱Ƃ͂ł܂B");
			}
			this.stream.Write(buffer, offset, count);
		}

		// private static \bh //

		private static void AssertArgumentBufferOffsetCount(byte[] buffer, int offset, int count)
		{
			ArgumentUtil.AssertNull(buffer, "buffer");
			if (offset < 0) {
				throw new ArgumentOutOfRangeException("offset", "0ȏłȂ΂Ȃ܂B");
			}
			if (count < 0) {
				throw new ArgumentOutOfRangeException("count", "0ȏłȂ΂Ȃ܂B");
			}
			if (offset + count > buffer.Length) {
				throw new ArgumentException("offset  count ̘a buffer ̒𒴂Ă܂B");
			}
		}
	}
}
