using System;
using System.Collections;
using System.IO;
using System.Text;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.IO
{
	/// <summary>
	/// PsǂݎĕԂ񋓎qJ܂B
	/// </summary>
	/// <remarks>
	/// IEnumerable Ă邽߁Aforeach Xe[ggŎgpł܂B
	/// </remarks>
	public class TextLineReader : IDisposable, IEnumerable
	{
		#region private fields
		private TextReader reader;
		private Enumerator enumerator;
		#endregion

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="s"></param>
		public TextLineReader(string s) : this(new StringReader(s)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="path"></param>
		/// <param name="encoding"></param>
		public TextLineReader(string path, Encoding encoding)
				: this(new StreamReader(path, encoding)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="stream"></param>
		/// <param name="encoding"></param>
		public TextLineReader(Stream stream, Encoding encoding)
				: this(new StreamReader(stream, encoding)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		public TextLineReader(TextReader reader)
		{
			ArgumentUtil.AssertNull(reader, "reader");
			this.reader = reader;
			this.enumerator = new Enumerator(this);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public void Dispose()
		{
			if (this.reader != null) {
				IDisposable d = this.reader;
				d.Dispose();
				this.reader = null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public string ReadLine()
		{
			this.enumerator.MoveNext();
			return this.enumerator.CurrentLine;
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.enumerator;
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		private class Enumerator : AbstractEnumerator, IDisposable
		{
			#region private fields
			private TextLineReader owner;
			#endregion

			// internal vpeB //

			/// <summary>
			/// 
			/// </summary>
			internal string CurrentLine
			{
				get {
					return (string)this.current;
				}
			}

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="owner"></param>
			internal Enumerator(TextLineReader owner)
			{
				this.owner = owner;
			}

			// public \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			protected override object MoveNextInternal()
			{
				return this.owner.reader.ReadLine();
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			void IDisposable.Dispose()
			{
				this.owner.Dispose();
			}
		}
	}
}
