using System;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;

using SystemNeo;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class AttributeUtil
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const string TypeIdPropertyName = "TypeId";

		// public static \bh //

		/// <summary>
		/// ĂvpeBƂ̒l񋓂܂B
		/// </summary>
		/// <param name="attribute"></param>
		/// <returns></returns>
		public static MemberValue[] GetPropertyValues(Attribute attribute)
		{
			ArgumentUtil.AssertNull(attribute, "attribute");
			Type attrType = attribute.GetType();

			BindingFlags bindingAttr = BindingFlags.Public | BindingFlags.Instance;
			var properties = new List<PropertyInfo>(attrType.GetProperties(bindingAttr));
			var fields = new List<FieldInfo>(attrType.GetFields(bindingAttr));
			var constructors = attrType.GetConstructors();
			var @params = new List<PropertyInfo>();

			for (int i = properties.Count - 1; i >= 0; i--) {
				if (properties[i].Name == TypeIdPropertyName) {
					properties.RemoveAt(i);
					break;
				}
			}

			if (properties.Count == 1) {
				var property = properties[0];
				Type[] types = {property.PropertyType};
				var method = MemberUtil.FindMethodByParemeterTypes(constructors, types);
				if (method != null) {
					@params.Add(property);
					properties.Clear();
				}
			}

			if (properties.Count > 0 && constructors.Length == 1) {
				var parameters = constructors[0].GetParameters();
				foreach (var parameter in parameters) {
					string propertyName = StringUtil.Capitalize(parameter.Name);
					var property = attrType.GetProperty(propertyName);
					if (property == null) {
						string msg = string.Format("^ {0} ɂ̓vpeB {1} ܂B",
								attrType.FullName, propertyName);
						throw new InvalidOperationException(msg);
					}
					@params.Add(property);
					properties.Remove(property);
				}
			}

			return GetPropertyValuesInternal(attribute, properties, fields, @params);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attribute"></param>
		/// <param name="properties"></param>
		/// <param name="fields"></param>
		/// <param name="params"></param>
		/// <returns></returns>
		private static MemberValue[] GetPropertyValuesInternal(
				Attribute attribute, IList<PropertyInfo> properties,
				IList<FieldInfo> fields, IList<PropertyInfo> @params)
		{
			int length = @params.Count + properties.Count + fields.Count;
			var result = new MemberValue[length];
			for (int i = 0; i < @params.Count; i++) {
				object value = @params[i].GetValue(attribute, null);
				result[i] = new MemberValue(null, value);
			}
			for (int i = 0; i < properties.Count; i++) {
				object value = properties[i].GetValue(attribute, null);
				result[@params.Count + i] = new MemberValue(properties[i], value);
			}
			for (int i = 0; i < fields.Count; i++) {
				object value = fields[i].GetValue(attribute);
				result[@params.Count + properties.Count + i] = new MemberValue(fields[i], value);
			}
			return result;
		}
	}
}
