using System;
using System.Globalization;
using System.Linq;
using System.Reflection;

using SystemNeo.Collections;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// tB[h\܂B
	/// <see cref="System.Reflection.FieldInfo">FieldInfo</see> ̑Ɏgpł܂B
	/// </summary>
	public sealed class FieldInfoNeo : MemberInfoNeo
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const string EnumValueFieldName = "value__";

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override MemberAccessibility Accessibility
		{
			get {
				if (this.AsField.IsPublic) {
					return MemberAccessibility.Public;
				}
				if (this.AsField.IsFamily) {
					return MemberAccessibility.Family;
				}
				if (this.AsField.IsFamilyAndAssembly) {
					return MemberAccessibility.FamilyAndAssembly;
				}
				if (this.AsField.IsFamilyOrAssembly) {
					return MemberAccessibility.FamilyOrAssembly;
				}
				if (this.AsField.IsAssembly) {
					return MemberAccessibility.Assembly;
				}
				if (this.AsField.IsPrivate) {
					return MemberAccessibility.Private;
				}
				return 0;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public object EnumValue
		{
			get {
				if (this.IsEnumValue) {
					FieldInfoNeo valueField = this.ReflectedType.GetField(EnumValueFieldName);
					object obj = this.GetValue(null);
					return valueField.GetValue(obj);
				} else {
					return null;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TypeNeo FieldType
		{
			get {
				return this.AsField.FieldType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsAbstract
		{
			get {
				return false;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsEnumValue
		{
			get {
				return (Type)this.ReflectedType.BaseType == typeof(Enum)
						&& this.IsStatic && this.IsLiteral;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsFinal
		{
			get {
				return true;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsInitOnly
		{
			get {
				return this.AsField.IsInitOnly;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsLiteral
		{
			get {
				return this.AsField.IsLiteral;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsSpecialName
		{
			get {
				return this.AsField.IsSpecialName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsStatic
		{
			get {
				return this.AsField.IsStatic;
			}
		}

		// private vpeB //

		/// <summary>
		/// 
		/// </summary>
		private FieldInfo AsField
		{
			get {
				return (FieldInfo)this.member;
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="field"></param>
		internal FieldInfoNeo(FieldInfo field) : base(field) {}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="fields"></param>
		/// <returns></returns>
		public static FieldInfoNeo[] ConvertArray(FieldInfo[] fields)
		{
			return fields == null ? null : Array.ConvertAll(fields, (f) => (FieldInfoNeo)f);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static FieldInfoNeo FromEnum(Enum value)
		{
			Type type = value.GetType();
			return (FieldInfoNeo)type.GetField(Enum.GetName(type, value));
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public object GetValue(object obj)
		{
			return this.AsField.GetValue(obj);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <param name="value"></param>
		public void SetValue(object obj, object value)
		{
			this.AsField.SetValue(obj, value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <param name="value"></param>
		/// <param name="invokeAttr"></param>
		/// <param name="binder"></param>
		/// <param name="culture"></param>
		public void SetValue(object obj,
				object value, BindingFlags invokeAttr, Binder binder, CultureInfo culture)
		{
			this.AsField.SetValue(obj, value, invokeAttr, binder, culture);
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="field"></param>
		/// <returns></returns>
		public static implicit operator FieldInfoNeo(FieldInfo field)
		{
			return (FieldInfoNeo)GetCachedInstance(field);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="field"></param>
		/// <returns></returns>
		public static explicit operator FieldInfo(FieldInfoNeo field)
		{
			if (field == null) {
				return null;
			} else {
				return field.AsField;
			}
		}
	}
}
