using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Runtime.InteropServices;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// ^̃oɊւ郁\bh񋟂܂B
	/// </summary>
	public static class MemberUtil
	{
		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const BindingFlags AllBindingFlags = BindingFlags.Public
				| BindingFlags.NonPublic | BindingFlags.Static | BindingFlags.Instance;

		/// <summary>
		/// fQ[g̎s\bhB
		/// </summary>
		public const string DelegateInvokeMethodName = "Invoke";

		/// <summary>
		/// fXgN^̃\bhB
		/// </summary>
		public const string DestructorMethodName = "Finalize";

		/// <summary>
		/// IȌ^ϊZq\\bhB
		/// </summary>
		public const string ExplicitOperatorMethodName = "op_Explicit";

		/// <summary>
		/// Öق̌^ϊZq\\bhB
		/// </summary>
		public const string ImplicitOperatorMethodName = "op_Implicit";

		// public static \bh //

		/// <summary>
		/// w肳ꂽ^ւ̃{bNXϊ\ǂ𔻒肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public static bool CanBox(Type expectedType, object value)
		{
			return value != null && CanBox(expectedType, value.GetType());
		}

		/// <summary>
		/// w肳ꂽ^ւ̃{bNXϊ\ǂ𔻒肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <param name="actualType"></param>
		/// <returns></returns>
		public static bool CanBox(Type expectedType, Type actualType)
		{
			ArgumentUtil.AssertNull(expectedType, "expectedType");
			ArgumentUtil.AssertNull(actualType, "actualType");
			return actualType.IsValueType && expectedType.IsAssignableFrom(actualType);
		}

		/// <summary>
		/// w肳ꂽ^ւ̈Öق̎Qƕϊ\ǂ𔻒肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public static bool CanConvertReferenceImplicitly(Type expectedType, object value)
		{
			// l null ̏ꍇAp[^Qƌ^ǂŔ肷
			if (value == null) {
				return ! expectedType.IsValueType;
			}
			return CanConvertReferenceImplicitly(expectedType, value.GetType());
		}

		/// <summary>
		/// w肳ꂽ^ւ̈Öق̎Qƕϊ\ǂ𔻒肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <param name="actualType"></param>
		/// <returns></returns>
		public static bool CanConvertReferenceImplicitly(Type expectedType, Type actualType)
		{
			ArgumentUtil.AssertNull(expectedType, "expectedType");
			ArgumentUtil.AssertNull(actualType, "actualType");
			if (expectedType.IsValueType || actualType.IsValueType) {
				return false;
			}
			// ľ^Ώۂ̌^hĂ true
			if (expectedType.IsAssignableFrom(actualType)) {
				return true;
			}
			// ҂̔z^ȂAvf^Ĕ肷
			if (expectedType.IsArray && actualType.IsArray) {
				if (expectedType.GetArrayRank() == actualType.GetArrayRank()) {
					Type expectedElement = expectedType.GetElementType();
					Type actualElement = actualType.GetElementType();
					return CanConvertReferenceImplicitly(expectedElement, actualElement);
				}
			}
			return false;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="mi1"></param>
		/// <param name="mi2"></param>
		/// <returns></returns>
		public static int CompareMemberInfo(MemberInfo mi1, MemberInfo mi2)
		{
			ArgumentUtil.AssertNull(mi1, "mi1");
			ArgumentUtil.AssertNull(mi2, "mi2");
			int result = 0;
			if (mi1 is Type && mi2 is Type) {
				result = CompareType((Type)mi1, (Type)mi2);
			}
			if (result == 0) {
				result = CompareType(mi1.GetType(), mi2.GetType());
			}
			if (result == 0) {
				result = CompareType(mi1.DeclaringType, mi2.DeclaringType);
			}
			if (result == 0) {
				result = string.Compare(mi1.Name, mi2.Name);
			}
			if (result == 0) {
				if (mi1 is ConstructorInfo || mi1 is MethodInfo) {
					ParameterInfo[] pi1 = ((MethodBase)mi1).GetParameters();
					ParameterInfo[] pi2 = ((MethodBase)mi2).GetParameters();
					result = CompareParams(pi1, pi2);
				}
				if (mi1 is PropertyInfo) {
					ParameterInfo[] pi1 = ((PropertyInfo)mi1).GetIndexParameters();
					ParameterInfo[] pi2 = ((PropertyInfo)mi2).GetIndexParameters();
					result = CompareParams(pi1, pi2);
				}
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static int CompareParams(ParameterInfo[] x, ParameterInfo[] y)
		{
			int result;
			if (CompareReference(x, y, out result)) {
				return result;
			}
			result = x.Length - y.Length;
			if (result != 0) {
				return result;
			}
			for (int i = 0; i < x.Length; i++) {
				result = CompareType(x[i].ParameterType, y[i].ParameterType);
				if (result != 0) {
					return result;
				}
			}
			return 0;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="compare"></param>
		/// <returns>
		/// x  y ̃CX^XA2̂1ȏオ null ̏ꍇ trueB
		/// ȊOix  y  null łȂAقȂCX^Xj̏ꍇ falseB
		/// </returns>
		public static bool CompareReference(object x, object y, out int compare)
		{
			if (object.ReferenceEquals(x, y)) {
				compare = 0;
				return true;
			}
			if (x == null) {
				compare = -1;
				return true;
			}
			if (y == null) {
				compare = 1;
				return true;
			}
			compare = 0;
			return false;
		}

		/// <summary>
		/// 2̌^̖Or܂B
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static int CompareType(Type x, Type y)
		{
			int result;
			if (CompareReference(x, y, out result)) {
				return result;
			}
			string xNamespace = StringUtil.EnsureNotNull(x.Namespace);
			string yNamespace = StringUtil.EnsureNotNull(y.Namespace);
			result = string.Compare(xNamespace, yNamespace);
			if (result == 0) {
				string xName = StringUtil.EnsureNotNull(x.Name);
				string yName = StringUtil.EnsureNotNull(y.Name);
				result = string.Compare(xName, yName);
			}
			return result;
		}

		/// <summary>
		/// \bh̔z̒Aw肳ꂽ^̈vf擾܂B
		/// </summary>
		/// <param name="methods"></param>
		/// <param name="parameterTypes"></param>
		/// <returns></returns>
		public static MethodBase FindMethodByParemeterTypes(
				MethodBase[] methods, params Type[] parameterTypes)
		{
			ArgumentUtil.AssertNull(methods, "methods");
			if (parameterTypes == null) {
				parameterTypes = new Type[0];
			}
			foreach (MethodBase method in methods) {
				if (MatchesParameterTypes(method.GetParameters(), parameterTypes)) {
					return method;
				}
			}
			return null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="memberType"></param>
		/// <param name="bindingAttr"></param>
		/// <param name="filter"></param>
		/// <returns></returns>
		public static MemberInfo[] FindMembers(
				MemberTypes memberType, BindingFlags bindingAttr, MemberFilter filter)
		{
			return FindMembers(memberType, bindingAttr, filter, null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="memberType"></param>
		/// <param name="bindingAttr"></param>
		/// <param name="filter"></param>
		/// <param name="filterCriteria"></param>
		/// <returns></returns>
		public static MemberInfo[] FindMembers(MemberTypes memberType,
				BindingFlags bindingAttr, MemberFilter filter, object filterCriteria)
		{
			return FindMembers(AppDomain.CurrentDomain.GetAssemblies(),
					memberType, bindingAttr, filter, filterCriteria);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="assemblies"></param>
		/// <param name="memberType"></param>
		/// <param name="bindingAttr"></param>
		/// <param name="filter"></param>
		/// <param name="filterCriteria"></param>
		/// <returns></returns>
		public static MemberInfo[] FindMembers(
				IEnumerable assemblies, MemberTypes memberType,
				BindingFlags bindingAttr, MemberFilter filter, object filterCriteria)
		{
			var list = new List<MemberInfo>();
			FindMembers(assemblies, memberType, bindingAttr, filter, filterCriteria, list);
			return list.ToArray();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="assemblies"></param>
		/// <param name="memberType"></param>
		/// <param name="bindingAttr"></param>
		/// <param name="filter"></param>
		/// <param name="filterCriteria"></param>
		/// <param name="found"></param>
		public static void FindMembers(IEnumerable assemblies,
				MemberTypes memberType, BindingFlags bindingAttr,
				MemberFilter filter, object filterCriteria, ICollection<MemberInfo> found)
		{
			foreach (Assembly asm in assemblies) {
				foreach (Type type in asm.GetTypes()) {
					var members = type.FindMembers(memberType, bindingAttr, filter, filterCriteria);
					foreach (var member in members) {
						found.Add(member);
					}
				}
			}
		}

		/// <summary>
		/// ^܂B
		/// </summary>
		/// <param name="filter"></param>
		/// <returns></returns>
		public static Type[] FindTypes(TypeFilter filter)
		{
			return FindTypes(filter, null);
		}

		/// <summary>
		/// ^܂B
		/// </summary>
		/// <param name="filter"></param>
		/// <param name="filterCriteria"></param>
		/// <returns></returns>
		public static Type[] FindTypes(TypeFilter filter, object filterCriteria)
		{
			Assembly[] assemblies = AppDomain.CurrentDomain.GetAssemblies();
			return FindTypes(assemblies, filter, filterCriteria);
		}

		/// <summary>
		/// ^܂B
		/// </summary>
		/// <param name="assemblies"></param>
		/// <param name="filter"></param>
		/// <param name="filterCriteria"></param>
		/// <returns></returns>
		public static Type[] FindTypes(IEnumerable assemblies,
				TypeFilter filter, object filterCriteria)
		{
			var list = new List<Type>();
			FindTypes(assemblies, filter, filterCriteria, list);
			return list.ToArray();
		}

		/// <summary>
		/// ^܂B
		/// </summary>
		/// <param name="assemblies"></param>
		/// <param name="filter"></param>
		/// <param name="filterCriteria"></param>
		/// <param name="found"></param>
		public static void FindTypes(IEnumerable assemblies,
				TypeFilter filter, object filterCriteria, ICollection<Type> found)
		{
			foreach (Assembly asm in assemblies) {
				foreach (Type type in asm.GetTypes()) {
					if (filter(type, filterCriteria)) {
						found.Add(type);
					}
				}
			}
		}

		/// <summary>
		/// w肳ꂽo̎QƉ\͈͂擾܂B
		/// </summary>
		/// <param name="member"></param>
		/// <returns></returns>
		public static MemberAccessibility GetAccessibility(MemberInfo member)
		{
			if (member is MethodBase) {
				return GetAccessibility((MethodBase)member);
			}
			if (member is Type) {
				return TypeUtil.GetAccessibility((Type)member);
			}
			// TODO: 
			throw new NotImplementedException();
		}

		/// <summary>
		/// w肳ꂽo̎QƉ\͈͂擾܂B
		/// </summary>
		/// <param name="method"></param>
		/// <returns></returns>
		public static MemberAccessibility GetAccessibility(MethodBase method)
		{
			if (method.IsPublic) {
				return MemberAccessibility.Public;
			}
			if (method.IsFamily) {
				return MemberAccessibility.Family;
			}
			if (method.IsFamilyAndAssembly) {
				return MemberAccessibility.FamilyAndAssembly;
			}
			if (method.IsFamilyOrAssembly) {
				return MemberAccessibility.FamilyOrAssembly;
			}
			if (method.IsAssembly) {
				return MemberAccessibility.Assembly;
			}
			if (method.IsPrivate) {
				return MemberAccessibility.Private;
			}
			return 0;
		}

		// TODO: \bh internal ɂB
		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public static int GetMemberInfoHashCode(object obj)
		{
			ArgumentUtil.AssertNull(obj, "obj");
			var member = (MemberInfo)obj;
			int result = member.Name.GetHashCode();
			Type t = member.DeclaringType;
			if (t != null) {
				result ^= t.GetHashCode();
			}
			if (member is ConstructorInfo || member is MethodInfo) {
				ParameterInfo[] parameters = ((MethodInfo)member).GetParameters();
				foreach (var param in parameters) {
					result ^= param.ParameterType.GetHashCode();
				}
			}
			if (member is PropertyInfo) {
				ParameterInfo[] parameters = ((PropertyInfo)member).GetIndexParameters();
				foreach (var param in parameters) {
					result ^= param.ParameterType.GetHashCode();
				}
			}
			return result;
		}

		/// <summary>
		/// w肳ꂽ^ɊUĂGUID擾܂B
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public static Guid GetGuid(Type type)
		{
			object[] attributes = type.GetCustomAttributes(typeof(GuidAttribute), false);
			if (attributes.Length == 0) {
				return new Guid(new string('0', 32));
			} else {
				var guidAttr = (GuidAttribute)attributes[0];
				return new Guid(guidAttr.Value);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TObject"></typeparam>
		/// <typeparam name="TProperty"></typeparam>
		/// <param name="propertyName"></param>
		/// <returns></returns>
		public static Func<TObject, TProperty>
				GetPropertyGetter<TObject, TProperty>(string propertyName)
		{
			ArgumentUtil.AssertNull(propertyName, "propertyName");
			BindingFlags bindingAttr = BindingFlags.Instance | BindingFlags.Public;
			PropertyInfo property = typeof(TObject).GetProperty(propertyName, bindingAttr);
			return (obj) => (TProperty)property.GetValue(obj, null);
		}

		/// <summary>
		/// w肳ꂽ^ւ̕ϊ\ǂ肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public static bool IsConvertable(Type expectedType, object value)
		{
			ArgumentUtil.AssertNull(expectedType, "expectedType");
			return CanConvertReferenceImplicitly(expectedType, value)
					|| CanBox(expectedType, value);
		}

		/// <summary>
		/// w肳ꂽ^ւ̕ϊ\ǂ肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <param name="actualType"></param>
		/// <returns></returns>
		public static bool IsConvertable(Type expectedType, Type actualType)
		{
			ArgumentUtil.AssertNull(expectedType, "expectedType");
			ArgumentUtil.AssertNull(actualType, "actualType");
			return CanConvertReferenceImplicitly(expectedType, actualType)
					|| CanBox(expectedType, actualType);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="method"></param>
		/// <param name="params"></param>
		/// <returns></returns>
		public static bool MatchesParameters(MethodBase method, object[] @params)
		{
			ArgumentUtil.AssertNull(method, "method");
			ParameterInfo[] parameters = method.GetParameters();
			if (parameters.Length != @params.Length) {
				return false;
			}
			for (int i = 0; i < parameters.Length; i++) {
				Type expectedType = parameters[i].ParameterType;
				if (expectedType.IsByRef) {
					return false;
				}
				if (! IsConvertable(expectedType, @params[i])) {
					return false;
				}
			}
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parameters"></param>
		/// <param name="types"></param>
		/// <returns></returns>
		public static bool MatchesParameterTypes(ParameterInfo[] parameters, Type[] types)
		{
			ArgumentUtil.AssertNull(parameters, "parameters");
			ArgumentUtil.AssertNull(types, "types");
			if (parameters.Length != types.Length) {
				return false;
			}
			for (int i = 0; i < parameters.Length; i++) {
				if (! IsConvertable(parameters[i].ParameterType, types[i])) {
					return false;
				}
			}
			return true;
		}

		// internal static \bh //

		/// <summary>
		/// ^ϊZq\\bh擾܂B
		/// </summary>
		/// <param name="conversionType"></param>
		/// <param name="originalType"></param>
		/// <returns></returns>
		internal static MethodInfo[] GetCastOperatorMethods(Type conversionType, Type originalType)
		{
			string imp = ImplicitOperatorMethodName;
			string exp = ExplicitOperatorMethodName;
			return new MethodInfo[] {
				GetCastOperatorMethod(imp, originalType,   originalType),
				GetCastOperatorMethod(imp, conversionType, originalType),
				GetCastOperatorMethod(exp, originalType,   originalType),
				GetCastOperatorMethod(exp, conversionType, originalType)
			};
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="methodName"></param>
		/// <param name="declaringType"></param>
		/// <param name="originalType"></param>
		/// <returns></returns>
		private static MethodInfo GetCastOperatorMethod(
				string methodName, Type declaringType, params Type[] originalType)
		{
			Debug.Assert(originalType.Length == 1);
			BindingFlags attr = BindingFlags.Public | BindingFlags.Static;
			return declaringType.GetMethod(methodName, attr, null, originalType, null);
		}
	}
}
