using System;
using System.Collections;
using System.Globalization;
using System.Reflection;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// \bh܂̓RXgN^\܂B
	/// <see cref="System.Reflection.MethodBase">MethodBase</see> ̑Ɏgpł܂B
	/// ͒ۃNXłB
	/// </summary>
	public abstract class MethodBaseNeo : ParameteredMember
	{
		// protected RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="method"></param>
		protected MethodBaseNeo(MethodBase method) : base(method) {}

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override MemberAccessibility Accessibility
		{
			get {
				if (this.AsMethod.IsPublic) {
					return MemberAccessibility.Public;
				}
				if (this.AsMethod.IsFamily) {
					return MemberAccessibility.Family;
				}
				if (this.AsMethod.IsFamilyAndAssembly) {
					return MemberAccessibility.FamilyAndAssembly;
				}
				if (this.AsMethod.IsFamilyOrAssembly) {
					return MemberAccessibility.FamilyOrAssembly;
				}
				if (this.AsMethod.IsAssembly) {
					return MemberAccessibility.Assembly;
				}
				if (this.AsMethod.IsPrivate) {
					return MemberAccessibility.Private;
				}
				return 0;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public MethodAttributes Attributes
		{
			get {
				return this.AsMethod.Attributes;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public CallingConventions CallingConvention
		{
			get
			{
				return this.AsMethod.CallingConvention;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public MethodImplAttributes ImplementationFlags
		{
			get {
				return this.AsMethod.GetMethodImplementationFlags();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsAbstract
		{
			get {
				return this.AsMethod.IsAbstract;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsFinal
		{
			get {
				return this.AsMethod.IsFinal;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsHideBySig
		{
			get {
				return this.AsMethod.IsHideBySig;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsOverloading
		{
			get {
				Type declaringType = this.AsMethod.DeclaringType;
				int count = 0;
				MethodInfo[] methods = declaringType.GetMethods(MemberUtil.AllBindingFlags);
				foreach (var method in methods) {
					if (method.Name == this.AsMethod.Name) {
						if (++count >= 2) {
							return true;
						}
					}
				}
				return false;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsSpecialName
		{
			get {
				return this.AsMethod.IsSpecialName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsStatic
		{
			get {
				return this.AsMethod.IsStatic;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsVirtual
		{
			get {
				return this.AsMethod.IsVirtual;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public RuntimeMethodHandle MethodHandle
		{
			get {
				return this.AsMethod.MethodHandle;
			}
		}

		// private vpeB //

		/// <summary>
		/// 
		/// </summary>
		private MethodBase AsMethod
		{
			get {
				return (MethodBase)member;
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public TypeNeo[] GetGenericArguments()
		{
			return TypeNeo.ConvertArray(this.AsMethod.GetGenericArguments());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public object Invoke(object obj, params object[] parameters)
		{
			return this.AsMethod.Invoke(obj, parameters);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override ParameterInfo[] GetParameters()
		{
			return this.AsMethod.GetParameters();
		}
	}
}
