using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text.RegularExpressions;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// ^錾\܂B
	/// <see cref="System.Type">Type</see> ̑Ɏgpł܂B
	/// </summary>
	public class TypeNeo : MemberInfoNeo, IComparable
	{
		#region private static fields
		private static readonly string[] genericArgumentBrackets = {"<", ">"};
		#endregion

		#region private fields
		private IDictionary<MethodInfo, EventInfo> eventAccessorDictionary;
		private IDictionary<MethodInfo, MethodInfo> interfaceMapping;
		private IDictionary<MethodInfo, PropertyInfo> propertyAccessorDictionary;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override MemberAccessibility Accessibility
		{
			get {
				if (this.AsType.IsPublic || this.AsType.IsNestedPublic) {
					return MemberAccessibility.Public;
				}
				if (this.AsType.IsNestedFamily) {
					return MemberAccessibility.Family;
				}
				if (this.AsType.IsNestedFamANDAssem) {
					return MemberAccessibility.FamilyAndAssembly;
				}
				if (this.AsType.IsNestedFamORAssem) {
					return MemberAccessibility.FamilyOrAssembly;
				}
				if (this.AsType.IsNestedAssembly) {
					return MemberAccessibility.Assembly;
				}
				if (this.AsType.IsNestedPrivate) {
					return MemberAccessibility.Private;
				}
				return MemberAccessibility.Assembly;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Assembly Assembly
		{
			get {
				return this.AsType.Assembly;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string AssemblyQualifiedName
		{
			get {
				return this.AsType.AssemblyQualifiedName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TypeAttributes Attributes
		{
			get {
				return this.AsType.Attributes;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TypeNeo BaseType
		{
			get {
				return this.AsType.BaseType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TypeNeo ElementType
		{
			get {
				return this.AsType.GetElementType();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public FieldInfoNeo EnumValueField
		{
			get {
				if (this.IsEnum) {
					return this.GetField(FieldInfoNeo.EnumValueFieldName);
				} else {
					return null;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string FullName
		{
			get {
				return this.AsType.FullName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public GenericParameterAttributes GenericParameterAttributes
		{
			get {
				return this.AsType.GenericParameterAttributes;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Guid GUID
		{
			get {
				return this.AsType.GUID;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool HasElementType
		{
			get {
				return this.AsType.HasElementType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsAbstract
		{
			get {
				return this.AsType.IsAbstract;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsArray
		{
			get {
				return this.AsType.IsArray;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsByRef
		{
			get {
				return this.AsType.IsByRef;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsClass
		{
			get {
				return this.AsType.IsClass;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsCOMObject
		{
			get {
				return this.AsType.IsCOMObject;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsDelegate
		{
			get {
				return this.AsType.BaseType == typeof(MulticastDelegate);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsEnum
		{
			get {
				return this.AsType.IsEnum;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsFinal
		{
			get {
				return this.AsType.IsSealed;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsInterface
		{
			get {
				return this.AsType.IsInterface;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsPointer
		{
			get {
				return this.AsType.IsPointer;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsPrimitive
		{
			get {
				return this.AsType.IsPrimitive;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsPublic
		{
			get {
				return this.AsType.IsPublic;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsSealed
		{
			get {
				return this.AsType.IsSealed;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsSerializable
		{
			get {
				return this.AsType.IsSerializable;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsSpecialName
		{
			get {
				return this.AsType.IsSpecialName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsStatic
		{
			get {
				return true;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsValueType
		{
			get {
				return this.AsType.IsValueType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Module Module
		{
			get {
				return this.AsType.Module;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string Namespace
		{
			get {
				return this.AsType.Namespace;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TypeCode TypeCode
		{
			get {
				return Type.GetTypeCode(this.AsType);
			}
		}

		// private vpeB //

		/// <summary>
		/// 
		/// </summary>
		private Type AsType
		{
			get {
				return (Type)member;
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		internal TypeNeo(Type type) : base(type) {}

		// public static \bh //

		/// <summary>
		/// {bNXϊ\ǂ𔻒肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <returns></returns>
		[Obsolete]
		public static bool CanBox(Type expectedType, object value)
		{
			return value != null && CanBox(expectedType, value.GetType());
		}

		/// <summary>
		/// {bNXϊ\ǂ𔻒肵܂B
		/// </summary>
		/// <param name="expectedType"></param>
		/// <param name="actualType"></param>
		/// <returns></returns>
		[Obsolete]
		public static bool CanBox(Type expectedType, Type actualType)
		{
			ArgumentUtil.AssertNull(expectedType, "expectedType");
			ArgumentUtil.AssertNull(actualType, "actualType");
			return actualType.IsValueType && expectedType.IsAssignableFrom(actualType);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="types"></param>
		/// <returns></returns>
		public static TypeNeo[] ConvertArray(Type[] types)
		{
			return types == null ? null : Array.ConvertAll(types, (t) => (TypeNeo)t);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public int CompareTo(object obj)
		{
			if (obj is TypeNeo) {
				return MemberUtil.CompareType(this.AsType, ((TypeNeo)obj).AsType);
			} else {
				throw new InvalidOperationException();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public object CreateInstance()
		{
			return this.CreateInstance(new object[] {});
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="param1"></param>
		/// <returns></returns>
		public object CreateInstance(object param1)
		{
			ArgumentUtil.AssertNull(param1, "param1");
			return this.CreateInstance(new object[] {param1});
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="param1"></param>
		/// <param name="param2"></param>
		/// <returns></returns>
		public object CreateInstance(object param1, object param2)
		{
			ArgumentUtil.AssertNull(param1, "param1");
			ArgumentUtil.AssertNull(param2, "param2");
			return this.CreateInstance(new object[] {param1, param2});
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="param1"></param>
		/// <param name="param2"></param>
		/// <param name="param3"></param>
		/// <returns></returns>
		public object CreateInstance(object param1, object param2, object param3)
		{
			ArgumentUtil.AssertNull(param1, "param1");
			ArgumentUtil.AssertNull(param2, "param2");
			ArgumentUtil.AssertNull(param3, "param3");
			return this.CreateInstance(new object[] {param1, param2, param3});
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public object CreateInstance(object[] parameters)
		{
			ArgumentUtil.AssertNull(parameters, "parameters");
			Type[] types = new Type[parameters.Length];
			for (int i = 0; i < parameters.Length; i++) {
				if (parameters[i] == null) {
					throw new ArgumentException("null QƂ܂ł܂B", "parameters");
				}
				types[i] = parameters[i].GetType();
			}
			return this.CreateInstance(MemberUtil.AllBindingFlags, types, parameters);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="types"></param>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public object CreateInstance(Type[] types, object[] parameters)
		{
			return this.CreateInstance(MemberUtil.AllBindingFlags, types, parameters);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <param name="types"></param>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public object CreateInstance(BindingFlags bindingAttr, Type[] types, object[] parameters)
		{
			ConstructorInfoNeo constructor = this.GetConstructor(bindingAttr, types);
			if (constructor == null || constructor.Accessibility == MemberAccessibility.Private) {
				return null;
			} else {
				return constructor.Invoke(parameters);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public int GetArrayRank()
		{
			return this.AsType.GetArrayRank();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public TypeNeo[] GetBaseTypes()
		{
			var list = new List<Type>();
			Type t = this.AsType;
			for (;;) {
				t = t.BaseType;
				if (t == null) {
					break;
				}
				list.Add(t);
			}
			return list.Cast<TypeNeo>().ToArray();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="types"></param>
		/// <returns></returns>
		public ConstructorInfoNeo GetConstructor(Type[] types)
		{
			return this.GetConstructor(MemberUtil.AllBindingFlags, types);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <param name="types"></param>
		/// <returns></returns>
		public ConstructorInfoNeo GetConstructor(BindingFlags bindingAttr, Type[] types)
		{
			return this.GetConstructor(bindingAttr, null, types);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <param name="binder"></param>
		/// <param name="types"></param>
		/// <returns></returns>
		public ConstructorInfoNeo GetConstructor(
				BindingFlags bindingAttr, Binder binder, Type[] types)
		{
			ArgumentUtil.AssertNull(types, "types");
			var modifiers = new ParameterModifier[types.Length];
			return this.AsType.GetConstructor(bindingAttr, binder, types, modifiers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public ConstructorInfoNeo[] GetConstructors()
		{
			return ConstructorInfoNeo.ConvertArray(this.AsType.GetConstructors());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		public ConstructorInfoNeo[] GetConstructors(BindingFlags bindingAttr)
		{
			return ConstructorInfoNeo.ConvertArray(this.AsType.GetConstructors(bindingAttr));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public MethodInfoNeo GetDelegateInvokeMethod()
		{
			if (this.IsDelegate) {
				return this.AsType.GetMethod(MemberUtil.DelegateInvokeMethodName);
			} else {
				return null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public EventInfoNeo[] GetEvents()
		{
			return EventInfoNeo.ConvertArray(this.AsType.GetEvents());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		public EventInfoNeo[] GetEvents(BindingFlags bindingAttr)
		{
			return EventInfoNeo.ConvertArray(this.AsType.GetEvents(bindingAttr));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <returns></returns>
		public FieldInfoNeo GetField(string name)
		{
			return this.AsType.GetField(name);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		public FieldInfoNeo GetField(string name, BindingFlags bindingAttr)
		{
			return this.AsType.GetField(name, bindingAttr);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public FieldInfoNeo[] GetFields()
		{
			return FieldInfoNeo.ConvertArray(this.AsType.GetFields());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		public FieldInfoNeo[] GetFields(BindingFlags bindingAttr)
		{
			return FieldInfoNeo.ConvertArray(this.AsType.GetFields(bindingAttr));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public TypeNeo[] GetGenericArguments()
		{
			return ConvertArray(this.AsType.GetGenericArguments());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public TypeNeo[] GetGenericParameterConstraints()
		{
			return ConvertArray(this.AsType.GetGenericParameterConstraints());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public TypeNeo[] GetInterfaces()
		{
			return this.GetInterfaces(true);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="inherit"></param>
		/// <returns></returns>
		public TypeNeo[] GetInterfaces(bool inherit)
		{
			IList<Type> interfaces = this.AsType.GetInterfaces();
			if (! inherit) {
				interfaces = FindNonBaseInterfaces(interfaces);
				if (this.AsType.BaseType != null) {
					foreach (Type intf in this.AsType.BaseType.GetInterfaces()) {
						interfaces.Remove(intf);
					}
				}
			}
			TypeNeo[] result = interfaces.Select(i => (TypeNeo)i).ToArray();
			Array.Sort(result);
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public MemberInfoNeo[] GetMembers()
		{
			return MemberInfoNeo.ConvertArray(this.AsType.GetMembers());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		public MemberInfoNeo[] GetMembers(BindingFlags bindingAttr)
		{
			return MemberInfoNeo.ConvertArray(this.AsType.GetMembers(bindingAttr));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public MethodInfoNeo[] GetMethods()
		{
			return MethodInfoNeo.ConvertArray(AsType.GetMethods());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		public MethodInfoNeo[] GetMethods(BindingFlags bindingAttr)
		{
			return MethodInfoNeo.ConvertArray(this.AsType.GetMethods(bindingAttr));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public PropertyInfoNeo[] GetProperties()
		{
			return PropertyInfoNeo.ConvertArray(this.AsType.GetProperties());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		public PropertyInfoNeo[] GetProperties(BindingFlags bindingAttr)
		{
			return PropertyInfoNeo.ConvertArray(this.AsType.GetProperties(bindingAttr));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <returns></returns>
		public PropertyInfoNeo GetProperty(string name)
		{
			return this.AsType.GetProperty(name);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public bool IsAssignableFrom(TypeNeo type)
		{
			return this.AsType.IsAssignableFrom(type.AsType);
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsGenericParameter
		{
			get {
				return this.AsType.IsGenericParameter;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsGenericType
		{
			get {
				return this.AsType.IsGenericType;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsGenericTypeDefinition
		{
			get {
				return this.AsType.IsGenericTypeDefinition;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public bool IsNumberValueType()
		{
			var numberValueTypes = new Type[] {
					typeof(byte),
					typeof(sbyte),
					typeof(short),
					typeof(ushort),
					typeof(int),
					typeof(uint),
					typeof(long),
					typeof(ulong),
					typeof(float),
					typeof(double),
					typeof(decimal)
			};
			return numberValueTypes.Contains(this.AsType);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public bool IsSubclassOf(TypeNeo type)
		{
			return this.AsType.IsSubclassOf(type.AsType);
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="method"></param>
		/// <returns></returns>
		internal MethodInfo GetMappedInterfaceMethod(MethodInfo method)
		{
			if (this.IsInterface) {
				return null;
			}
			try {
				return this.GetInterfaceMapping()[method];
			} catch (KeyNotFoundException) {
				return null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="accessor"></param>
		/// <returns></returns>
		internal EventInfo GetEventFromAccessor(MethodInfo accessor)
		{
			try {
				return this.GetEventAccessorDictionary()[accessor];
			} catch (KeyNotFoundException) {
				return null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="accessor"></param>
		/// <returns></returns>
		internal PropertyInfo GetPropertyFromAccessor(MethodInfo accessor)
		{
			try {
				return this.GetPropertyAccessorDictionary()[accessor];
			} catch (KeyNotFoundException) {
				return null;
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <returns></returns>
		private static IDictionary<TKey, TValue> CreateDictionary<TKey, TValue>()
				where TKey : MemberInfo
		{
			return new Dictionary<TKey, TValue>(new EqualityComparer<TKey>());
		}

		/// <summary>
		/// p[^œnꂽC^[tF[XQ̐eq֌W𒲂ׁA
		/// ̃C^[tF[X̐ełȂC^[tF[X𒊏o܂B
		/// </summary>
		/// <param name="interfaces"></param>
		/// <returns></returns>
		private static IList<Type> FindNonBaseInterfaces(IList<Type> interfaces)
		{
			var result = new List<Type>(interfaces);
			foreach (Type intf in interfaces) {
				if (! intf.IsInterface) {
					throw new ArgumentException();
				}
				foreach (Type intf2 in intf.GetInterfaces()) {
					result.Remove(intf2);
				}
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="methodName"></param>
		/// <param name="declaringType"></param>
		/// <param name="originalType"></param>
		/// <returns></returns>
		[Obsolete]
		private static MethodInfo GetCastOperatorMethodInternal(
				string methodName, Type declaringType, params Type[] originalType)
		{
			Debug.Assert(originalType.Length == 1);
			BindingFlags attr = BindingFlags.Public | BindingFlags.Static;
			return declaringType.GetMethod(methodName, attr, null, originalType, null);
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private IDictionary<MethodInfo, EventInfo> GetEventAccessorDictionary()
		{
			lock (this) {
				if (eventAccessorDictionary == null) {
					eventAccessorDictionary = CreateDictionary<MethodInfo, EventInfo>();
					EventInfo[] events = this.AsType.GetEvents(MemberUtil.AllBindingFlags);
					foreach (var eventInfo in events) {
						eventAccessorDictionary[eventInfo.GetAddMethod(true)] = eventInfo;
						eventAccessorDictionary[eventInfo.GetRemoveMethod(true)] = eventInfo;
					}
				}
			}
			return eventAccessorDictionary;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private IDictionary<MethodInfo, MethodInfo> GetInterfaceMapping()
		{
			lock (this) {
				if (interfaceMapping == null) {
					interfaceMapping = CreateDictionary<MethodInfo, MethodInfo>();
					foreach (Type intf in this.AsType.GetInterfaces()) {
						InterfaceMapping map = this.AsType.GetInterfaceMap(intf);
						for (int i = 0; i < map.TargetMethods.Length; i++) {
							interfaceMapping[map.TargetMethods[i]] = map.InterfaceMethods[i];
						}
					}
				}
				return interfaceMapping;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private IDictionary<MethodInfo, PropertyInfo> GetPropertyAccessorDictionary()
		{
			lock (this) {
				if (propertyAccessorDictionary == null) {
					propertyAccessorDictionary = CreateDictionary<MethodInfo, PropertyInfo>();
					PropertyInfo[] properties
							= this.AsType.GetProperties(MemberUtil.AllBindingFlags);
					foreach (var property in properties) {
						foreach (MethodInfo accessor in property.GetAccessors(true)) {
							propertyAccessorDictionary[accessor] = property;
						}
					}
				}
			}
			return propertyAccessorDictionary;
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public static implicit operator TypeNeo(Type type)
		{
			return (TypeNeo)GetCachedInstance(type);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public static explicit operator Type(TypeNeo type)
		{
			return type == null ? null : type.AsType;
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		private struct EqualityComparer<T> : IEqualityComparer<T> where T : MemberInfo
		{
			/// <summary>
			/// 
			/// </summary>
			/// <param name="x"></param>
			/// <param name="y"></param>
			/// <returns></returns>
			bool IEqualityComparer<T>.Equals(T x, T y)
			{
				return (MemberUtil.CompareMemberInfo(x, y) == 0);
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="obj"></param>
			/// <returns></returns>
			int IEqualityComparer<T>.GetHashCode(T obj)
			{
				return MemberUtil.GetMemberInfoHashCode(obj);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public struct TypeExComparer : IComparer
		{
			int IComparer.Compare(object x, object y)
			{
				Type tx = (Type)(TypeNeo)x;
				Type ty = (Type)(TypeNeo)y;
				return MemberUtil.CompareType(tx, ty);
			}
		}
	}
}
