using System;
using System.Collections;
using System.IO;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class QuotedStringFormatter : StringFormatter
	{
		#region private static fields
		private static readonly IDictionary decodeCharDic = new Hashtable();
		private static readonly IDictionary encodeCharDic = new Hashtable();
		#endregion

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static QuotedStringFormatter()
		{
			InitializeChar('\0', '0');
			InitializeChar('\a', 'a');
			InitializeChar('\b', 'b');
			InitializeChar('\f', 'f');
			InitializeChar('\n', 'n');
			InitializeChar('\r', 'r');
			InitializeChar('\t', 't');
			InitializeChar('\v', 'v');
			InitializeChar('\\', '\\');
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public QuotedStringFormatter() : base(0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="maxLength"></param>
		public QuotedStringFormatter(int maxLength) : base(maxLength) {}

		// protected internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			if (value is string) {
				int index = 0;
				writer.Write('"');
				foreach (char c in (string)value) {
					if (this.MaxLength > 0 && index++ > this.MaxLength) {
						writer.Write(this.EllipsisExpression);
						break;
					}
					WriteChar(writer, c);
				}
				writer.Write('"');
			} else {
				throw new NotSupportedException();
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="plainChar"></param>
		/// <param name="escapeChar"></param>
		private static void InitializeChar(char plainChar, char escapeChar)
		{
			decodeCharDic[escapeChar] = plainChar;
			encodeCharDic[plainChar] = escapeChar;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="c"></param>
		private static void WriteChar(TextWriter writer, char c)
		{
			switch (c) {
			case '"':
				writer.Write(@"\""");
				break;
			default:
				if (encodeCharDic.Contains(c)) {
					writer.Write(@"\");
					writer.Write(encodeCharDic[c]);
				} else if (c < ' ') {
					writer.Write(@"\x{0:X4}", (ushort)c);
				} else {
					writer.Write(c);
				}
				break;
			}
		}
	}
}
