using System;
using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

using SystemNeo;
using SystemNeo.Collections.Generic;

namespace SystemNeo.Text.RegularExpressions
{
	/// <summary>
	/// 
	/// </summary>
	public class GroupDictionary : AbstractDictionary<string, string>
	{
		#region private fields
		private readonly Regex regex;
		private readonly GroupCollection collection;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override int Count
		{
			get {
				return this.collection.Count;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="regex"></param>
		/// <param name="collection"></param>
		public GroupDictionary(Regex regex, GroupCollection collection) : base(true)
		{
			ArgumentUtil.AssertNull(collection, "collection");
			this.regex = regex;
			this.collection = collection;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="regex"></param>
		/// <param name="match"></param>
		public GroupDictionary(Regex regex, Match match) : this(regex, match.Groups) {}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		protected override string Get(string key)
		{
			return this.collection[key].Value;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected override IEnumerable<KeyValuePair<string, string>> GetEnumeratorInternal()
		{
			foreach (string key in this.GetKeys()) {
				yield return new KeyValuePair<string, string>(key, this.collection[key].Value);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected override ICollection<string> GetKeys()
		{
			if (this.regex == null) {
				throw new InvalidOperationException();
			}
			return this.regex.GetGroupNames();
		}
	}
}
