using System;
using System.ComponentModel;
using System.IO;

using SystemNeo;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class StringFormatter : AbstractFormatter
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public static readonly StringFormatter Default = new StringFormatter();

		/// <summary>
		/// 
		/// </summary>
		public const string DefaultEllipsisExpression = "...";

		#region private fields
		private string ellipsisExpression = DefaultEllipsisExpression;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(DefaultEllipsisExpression)]
		public string EllipsisExpression
		{
			get {
				return this.ellipsisExpression;
			}
			set {
				this.ellipsisExpression = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(0)]
		public int MaxLength { get; set; }

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public StringFormatter() : this(0) {}
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="maxLength"></param>
		public StringFormatter(int maxLength)
		{
			this.MaxLength = maxLength;
		}

		// protected internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			if (value is string) {
				string s = (string)value;
				if (this.MaxLength > 0 && s.Length > this.MaxLength) {
					writer.Write(s.Substring(0, this.MaxLength));
					writer.Write(this.ellipsisExpression);
				} else {
					writer.Write(s);
				}
			} else {
				throw new ArgumentException();
			}
		}
	}
}
