using System;
using System.Collections;
using System.Text;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class TextElementCollection : TextElement, IEnumerable
	{
		/// <summary>
		/// 
		/// </summary>
		protected readonly TextElement[] elements;

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elements"></param>
		public TextElementCollection(params TextElement[] elements) : base(ConcatSrcText(elements))
		{
			this.elements = elements;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public TextElement[] GetElements()
		{
			var result = new TextElement[this.elements.Length];
			Array.Copy(this.elements, result, this.elements.Length);
			return result;
		}
        
		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elements"></param>
		/// <returns></returns>
		private static string ConcatSrcText(TextElement[] elements)
		{
			ArgumentUtil.AssertNull(elements, "elements");
			var sb = new StringBuilder();
			foreach (var element in elements) {
				sb.Append(element.SourceText);
			}
			return sb.ToString();
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.GetElements().GetEnumerator();
		}
	}
}
