﻿using System;
using System.Collections.Generic;
using System.IO;

namespace SystemNeo.Xml.Tiny
{
	/// <summary>
	/// 
	/// </summary>
	public class TinyXmlElement : TinyXmlNode
	{
		#region private static fields
		private const int CapacityStep = 4;
		#endregion

		#region private fields
		private string name;
		private string[] attributes;
		#endregion

		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		public override string Name
		{
			get {
				return this.name;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override TinyXmlNode ParentNode
		{
			get {
				return base.parentNode;
			}
		}

		// internal コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		internal TinyXmlElement(string name)
		{
			ArgumentUtil.AssertNull(name, "name");
			this.name = string.Intern(name);
		}

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <returns></returns>
		public string GetAttribute(string name)
		{
			int index = this.IndexOfAttribute(name);
			if (index < 0 || this.attributes[index] == null) {
				return string.Empty;
			} else {
				return this.attributes[index + 1];
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="value"></param>
		public void SetAttribute(string name, string value)
		{
			ArgumentUtil.AssertNull(name, "name");
			ArgumentUtil.AssertNull(value, "value");
			name = string.Intern(name);
			value = string.Intern(value);
			int index = this.IndexOfAttribute(name);
			if (index >= 0) {
				this.attributes[index] = name;
				this.attributes[index + 1] = value;
			} else if (this.attributes == null) {
				this.attributes = new string[CapacityStep];
				this.attributes[0] = name;
				this.attributes[1] = value;
			} else {
				int len = this.attributes.Length;
				string[] newAttributes = new string[len + CapacityStep];
				Array.Copy(this.attributes, newAttributes, len);
				newAttributes[len] = name;
				newAttributes[len + 1] = value;
				this.attributes = newAttributes;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			StringWriter sw = new StringWriter();
			sw.Write("<");
			sw.Write(this.name);
			if (this.attributes != null) {
				for (int i = 0; i < this.attributes.Length && this.attributes[i] != null; i += 2) {
					sw.Write(" ");
					sw.Write(this.attributes[i]);
					sw.Write("=\"");
					sw.Write(this.attributes[i + 1]);
					sw.Write("\"");
				}
			}
			sw.Write(">");
			return sw.ToString();
		}

		// private メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <returns></returns>
		private int IndexOfAttribute(string name)
		{
			if (this.attributes == null) {
				return -1;
			}
			for (int i = 0; i < this.attributes.Length; i += 2) {
				if (this.attributes[i] == null || this.attributes[i] == name) {
					return i;
				}
			}
			return -1;
		}
	}
}
