﻿using System;
using System.Xml;

namespace SystemNeo.Xml.Tiny
{
	/// <summary>
	/// 
	/// </summary>
	class TinyXmlLoader
	{
		#region private fields
		private TinyXmlDocument doc;
		private XmlReader reader;
		#endregion

		internal void Load(TinyXmlDocument doc, XmlReader reader)
		{
			ArgumentUtil.AssertNull(doc, "doc");
			ArgumentUtil.AssertNull(reader, "reader");
			this.doc = doc;
			this.reader = reader;
			if (reader.ReadState == ReadState.Interactive || reader.Read()) {
				this.LoadDocSequence(doc);
			}
		}

		private void IgnoreNamespace()
		{
			if (this.reader.Prefix != "" || this.reader.NamespaceURI != "") {
				throw new NotSupportedException("名前空間はサポートしていません。");
			}
		}

		private void LoadAttribute(TinyXmlElement element)
		{
			string name = this.reader.LocalName;
			string value = null;
			this.IgnoreNamespace();

			while (this.reader.ReadAttributeValue()) {
				switch (this.reader.NodeType) {
					case XmlNodeType.Text:
						value = this.reader.Value;
						break;
					default:
						throw new NotSupportedException();
				}
				element.SetAttribute(name, value);
			}
		}

		private TinyXmlDeclaration LoadDeclarationNode()
		{
			while (this.reader.MoveToNextAttribute()) {
			}
			return this.doc.CreateXmlDeclaration();
		}

		private void LoadDocSequence(TinyXmlDocument parentDoc)
		{
			TinyXmlNode newChild;
			while ((newChild = this.LoadNode()) != null) {
				parentDoc.AppendChildForLoad(newChild, parentDoc);
				if (! this.reader.Read()) {
					return;
				}
			}
		}

		private TinyXmlNode LoadNode()
		{
			TinyXmlElement element;
			TinyXmlNode node2;
			TinyXmlNode parentNode = null;
			do {
				node2 = null;
				switch (this.reader.NodeType) {
					case XmlNodeType.Element:
						bool isEmptyElement = this.reader.IsEmptyElement;
						this.IgnoreNamespace();
						element = this.doc.CreateElement(this.reader.LocalName);
						if (reader.MoveToFirstAttribute()) {
							do {
								this.LoadAttribute(element);
							} while (this.reader.MoveToNextAttribute());
							this.reader.MoveToElement();
						}
						if (! isEmptyElement) {
							if (parentNode != null) {
								parentNode.AppendChildForLoad(element, this.doc);
							}
							parentNode = element;
							continue;
						}
						node2 = element;
						break;
					case XmlNodeType.Whitespace:
						continue;
					case XmlNodeType.EndElement:
						if (parentNode != null) {
							if (parentNode.ParentNode == null) {
								return parentNode;
							}
							parentNode = parentNode.ParentNode;
							continue;
						}
						return null;
					case XmlNodeType.XmlDeclaration:
						node2 = this.LoadDeclarationNode();
						break;
					default:
						string message = string.Format("ノードタイプ {0} はサポートしていません。", this.reader.NodeType);
						throw new NotSupportedException();
				}
				if (parentNode != null) {
					parentNode.AppendChildForLoad(node2, this.doc);
				} else {
					return node2;
				}
			} while (this.reader.Read());

			if (parentNode != null) {
				while (parentNode.ParentNode != null) {
					parentNode = parentNode.ParentNode;
				}
			}
			return parentNode;
		}
	}
}
