﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SystemNeo.Xml.Tiny
{
	/// <summary>
	/// 
	/// </summary>
	public class TinyXmlNode
	{
		internal TinyXmlNode parentNode;

		internal TinyXmlNode[] childNodes;

		#region private static fields
		private const int CapacityStep = 4;
		#endregion

		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		public virtual TinyXmlNodeList ChildNodes
		{
			get {
				return new TinyXmlChildNodes(this);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public virtual string Name
		{
			get {
				return null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public virtual TinyXmlNode ParentNode {
			get {
				if (this.parentNode.parentNode is TinyXmlDocument) {
					throw new NotImplementedException();
				} else {
					return this.parentNode;
				}
			}
		}

		// internal メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="newChild"></param>
		/// <param name="doc"></param>
		/// <returns></returns>
		internal virtual TinyXmlNode AppendChildForLoad(TinyXmlNode newChild, TinyXmlDocument doc)
		{
			TinyXmlNode[] nodes = this.GetChildNodesArray(1);
			nodes[this.GetChildCount()] = newChild;
			newChild.SetParentForLoad(this);
			return newChild;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		internal int GetChildCount()
		{
			if (this.childNodes == null) {
				return 0;
			}
			int result = this.childNodes.Length;
			while (result > 0 && this.childNodes[result - 1] == null) {
				result--;
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		internal virtual void SetParentForLoad(TinyXmlNode node)
		{
			this.parentNode = node;
		}

		// private メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private TinyXmlNode[] GetChildNodesArray(int expand)
		{
			if (expand < 0) {
				throw new ArgumentOutOfRangeException();
			}
			if (this.childNodes == null) {
				this.childNodes = new TinyXmlNode[Math.Max(expand, CapacityStep)];
			} else {
				int childCount = this.GetChildCount();
				if (childCount + expand > this.childNodes.Length) {
					var newChildNodes = new TinyXmlNode[childCount + expand + CapacityStep];
					Array.Copy(this.childNodes, newChildNodes, childCount);
					this.childNodes = newChildNodes;
				}
			}
			return this.childNodes;
		}
	}
}
