using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;

using SystemNeo;
using SystemNeo.Collections.Generic;

namespace SystemNeo.Xml.XPath
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class XPathDictionary : AbstractDictionary<string, string>
	{
		#region private fields
		private readonly XmlNode node;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override int Count
		{
			get {
				throw new NotSupportedException();
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		public XPathDictionary(XmlNode node) : base(false)
		{
			ArgumentUtil.AssertNull(node, "node");
			this.node = node;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public override bool ContainsKey(string key)
		{
			return (this.node.SelectSingleNode(key) != null);
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		protected override string Get(string key)
		{
			ArgumentUtil.AssertNull(key, "key");
			if (key.StartsWith("@")) {
				return XmlUtil.GetAttribute(this.node, key.Substring(1));
			}
			XmlNode node = this.node.SelectSingleNode(key);
			if (node == null) {
				return null;
			}
			if (node is XmlAttribute) {
				return ((XmlAttribute)node).Value;
			}
			if (node is XmlText) {
				return ((XmlText)node).Value;
			}
			throw new NotSupportedException("XPath ̎wm[hłeLXgł܂B");
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected override IEnumerable<KeyValuePair<string, string>> GetEnumeratorInternal()
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		protected override void Set(string key, string value)
		{
			XmlNode node = this.node.SelectSingleNode(key);
			if (node is XmlAttribute) {
				((XmlAttribute)node).Value = value;
			}
			if (node is XmlText) {
				((XmlText)node).Value = value;
			}
			throw new ArgumentException();
		}
	}
}
