using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Xml;
using System.Xml.XPath;

using SystemNeo;
using SystemNeo.Collections;
using SystemNeo.Collections.Generic;
using SystemNeo.Text;

namespace SystemNeo.Xml.XPath
{
	/// <summary>
	/// XPath Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class XPathUtil
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attributes"></param>
		/// <returns></returns>
		public static string CreateAttributesCondition(IList attributes)
		{
			return CreateAttributesCondition(DictionaryUtil.Create(attributes));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attributes"></param>
		/// <returns></returns>
		public static string CreateAttributesCondition(IDictionary attributes)
		{
			return CreateAttributesConditionFormatter<object, object>().ToString(attributes);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="attributes"></param>
		/// <returns></returns>
		public static string CreateAttributesCondition
				<TKey, TValue>(IDictionary<TKey, TValue> attributes)
		{
			return CreateAttributesConditionFormatter<TKey, TValue>().ToString(attributes);
		}

		/// <summary>
		/// XPath ɂ镶\쐬܂B
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string CreateStringExpression(object value)
		{
			string s = Convert.ToString(value);
			string[] arr = s.Split('\'');
			if (arr.Length == 1) {
				return "'" + s + "'";
			} else {
				var formatter = new CollectionFormatter() {
					BeginBracket = "concat('",
					EndBracket = "')",
					Separator = "',\"'\",'"
				};
				return formatter.ToString(arr);
			}
		}

		/// <summary>
		/// w肳ꂽm[hƂAw XPath vZ܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="xpath"></param>
		/// <returns></returns>
		[Obsolete("Get() gpĂB")]
		public static string EvaluateXPath(XmlNode baseNode, string xpath)
		{
			return EvaluateXPath(baseNode, xpath, false, null);
		}

		/// <summary>
		/// w肳ꂽm[hƂAw XPath vZ܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="xpath"></param>
		/// <param name="multipleValue"></param>
		/// <param name="multipleValueFormatter"></param>
		/// <returns></returns>
		public static string EvaluateXPath(XmlNode baseNode,
				string xpath, bool multipleValue, IFormatter multipleValueFormatter)
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			ArgumentUtil.AssertNull(xpath, "xpath");
			if (multipleValue) {
				ArgumentUtil.AssertNull(multipleValueFormatter, "multipleValueFormatter");
			} else if (xpath[0] == '@') {
				return XmlUtil.GetAttribute(baseNode, xpath.Substring(1));
			}
			object value = baseNode.CreateNavigator().Evaluate(xpath);
			if (value is XPathNodeIterator) {
				var values = from XPathItem item in (XPathNodeIterator)value
							 select item.Value;
				if (multipleValue) {
					return multipleValueFormatter.ToString(values);
				} else {
					try {
						return values.First();
					} catch (InvalidOperationException) {
						return string.Empty;
					}
				}
			} else {
				return value.ToString();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="format"></param>
		/// <returns></returns>
		public static string Format(this XmlNode baseNode, string format)
		{
			return new XPathDictionary(baseNode).Format(format);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="xpath"></param>
		/// <returns></returns>
		public static string Get(this XmlNode baseNode, string xpath)
		{
			return EvaluateXPath(baseNode, xpath, false, null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="xpath"></param>
		/// <returns></returns>
		public static T GetAs<T>(this XmlNode baseNode, string xpath)
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			ArgumentUtil.AssertNull(xpath, "xpath");
			return (T)baseNode.CreateNavigator().Evaluate(xpath);
		}
		
		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="obj"></param>
		/// <returns></returns>
		private static string AddAtmark<T>(T obj)
		{
			return "@" + obj;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <returns></returns>
		private static Formatter CreateAttributesConditionFormatter<TKey, TValue>()
		{
			var formatter = new Formatter();
			SystemNeo.Text.DictionaryFormatter df = formatter.DictionaryFormatter;
			df.BeginBracket = "[";
			df.EndBracket   = "]";
			df.Binder = "=";
			df.Separator = " and ";
			df.KeyFormatter = FormatterFactory.Get<TKey>(AddAtmark);
			df.ValueFormatter = FormatterFactory.Get<TValue>(CreateStringExpression);
			return formatter;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="obj"></param>
		/// <returns></returns>
		private static string CreateStringExpression<T>(T obj)
		{
			return CreateStringExpression((object)obj);
		}
	}
}
