using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;

using SystemNeo;
using SystemNeo.Collections.Generic;

namespace SystemNeo.Xml
{
	/// <summary>
	/// XML ̖̑Oƒl̃yÃRNVłB
	/// </summary>
	public class XmlAttributeDictionary : AbstractDictionary<string, string>
	{
		#region private fields
		private readonly XmlAttributeCollection collection;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override int Count
		{
			get {
				return this.collection.Count;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attributes"></param>
		public XmlAttributeDictionary(XmlAttributeCollection attributes) : base(false)
		{
			ArgumentUtil.AssertNull(attributes, "attributes");
			this.collection = attributes;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		public XmlAttributeDictionary(XmlNode node) : this(node.Attributes) {}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		public void Add(object key, object value)
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		public override void Clear()
		{
			this.collection.RemoveAll();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public bool Contains(object key)
		{
			return this.collection[(string)key] != null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="array"></param>
		/// <param name="index"></param>
		public void CopyTo(Array array, int index)
		{
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		public void Remove(object key)
		{
			this.collection.Remove((XmlAttribute)key);
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		protected override string Get(string key)
		{
			XmlAttribute attr = this.collection[key];
			return attr == null ? null : attr.Value;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected override IEnumerable<KeyValuePair<string, string>> GetEnumeratorInternal()
		{
			foreach (XmlAttribute attr in this.collection) {
				yield return new KeyValuePair<string, string>(attr.Name, attr.Value);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="value"></param>
		protected override void Set(string key, string value)
		{
			XmlAttribute attr = this.collection[key];
			if (attr == null) {
				this.Add(key, value);
			} else {
				attr.Value = value;
			}
		}
	}
}
