using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Xml
{
	/// <summary>
	///
	/// </summary>
	public class XmlTreeManager : TreeManager
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public static readonly XmlTreeManager Default = new XmlTreeManager();
		
		// public \bh //

		/// <summary>
		/// <paramref name="parent"/> Ŏw肳ꂽm[h̎qm[hƂāA
		/// <paramref name="child"/> Ŏw肳ꂽm[hǉ܂B
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <exception cref="System.ArgumentException">
		/// <paramref name="parent"/>  <paramref name="child"/> Lȃm[hł͂܂B
		/// </exception>
		public override void AddChild(object parent, object child)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(XmlNode));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(XmlNode));
			((XmlNode)parent).AppendChild((XmlNode)child);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode">ΏۂƂm[hc[̐擪̃m[hB</param>
		/// <param name="match">m[h̏`郁\bhB</param>
		/// <returns></returns>
		public XmlNode FindFirst(XmlNode baseNode, Func<XmlNode, bool> match)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode">ΏۂƂm[hc[̐擪̃m[hB</param>
		/// <param name="match">m[h̏`郁\bhB</param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public XmlNode FindFirst(XmlNode baseNode, Func<XmlNode, bool> match, int depth)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode">ΏۂƂm[hc[̐擪̃m[hB</param>
		/// <param name="match">m[h̏`郁\bhB</param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public XmlNode FindFirst(XmlNode baseNode,
				Func<XmlNode, bool> match, TreeSearchAlgorithm algorithm, int depth)
		{
			return base.FindFirst(baseNode, match, algorithm, depth);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode">ΏۂƂm[hc[̐擪̃m[hB</param>
		/// <param name="match">m[h̏`郁\bhB</param>
		/// <returns></returns>
		public XmlElement FindFirst(XmlNode baseNode, Func<XmlElement, bool> match)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode">ΏۂƂm[hc[̐擪̃m[hB</param>
		/// <param name="match">m[h̏`郁\bhB</param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public XmlElement FindFirst(XmlNode baseNode, Func<XmlElement, bool> match, int depth)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// w肳ꂽm[h̎q̂Aw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="baseNode">ΏۂƂm[hc[̐擪̃m[hB</param>
		/// <param name="match">m[h̏`郁\bhB</param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public XmlElement FindFirst(XmlNode baseNode,
				Func<XmlElement, bool> match, TreeSearchAlgorithm algorithm, int depth)
		{
			return base.FindFirst(baseNode, match, algorithm, depth);
		}

		/// <summary>
		/// w肳ꂽm[hɂm[ĥAw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public XmlNode FindNext(XmlNode currentNode, Func<XmlNode, bool> match, bool loop)
		{
			return base.FindNext(currentNode, match, loop);
		}

		/// <summary>
		/// w肳ꂽm[hɂm[ĥAw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public XmlElement FindNext(XmlNode currentNode, Func<XmlElement, bool> match, bool loop)
		{
			return base.FindNext(currentNode, match, loop);
		}

		/// <summary>
		/// w肳ꂽm[h̒i邢͖jɂm[ĥAw肳ꂽɍŏ̃m[h擾܂B
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public XmlElement FindNextSibling(XmlElement currentNode, Func<XmlElement, bool> match)
		{
			return base.FindNextSibling(currentNode, match);
		}

		/// <summary>
		/// w肳ꂽm[hOɂm[ĥAw肳ꂽɍŌ̃m[h擾܂B
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public XmlNode FindPrevious(XmlNode currentNode, Func<XmlNode, bool> match, bool loop)
		{
			return base.FindPrevious(currentNode, match, loop);
		}

		/// <summary>
		/// w肳ꂽm[hOɂm[ĥAw肳ꂽɍŌ̃m[h擾܂B
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public XmlElement FindPrevious(
				XmlNode currentNode, Func<XmlElement, bool> match, bool loop)
		{
			return base.FindPrevious(currentNode, match, loop);
		}

		/// <summary>
		/// w肳ꂽm[ȟZi邢͎ojɂm[ĥAw肳ꂽɍŌ̃m[h擾܂B
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public XmlElement FindPreviousSibling(XmlElement currentNode, Func<XmlElement, bool> match)
		{
			return base.FindPreviousSibling(currentNode, match);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		public void ForEach(XmlNode baseNode, Action<XmlNode> action)
		{
			base.ForEach(baseNode, action, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="depth"></param>
		public void ForEach(XmlNode baseNode, Action<XmlNode> action, int depth)
		{
			base.ForEach(baseNode, action, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		public void ForEach(XmlNode baseNode,
				Action<XmlNode> action, TreeSearchAlgorithm algorithm, int depth)
		{
			base.ForEach(baseNode, action, algorithm, depth);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		public void ForEach(XmlNode baseNode, Action<XmlElement> action)
		{
			base.ForEach(baseNode, action, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="depth"></param>
		public void ForEach(XmlNode baseNode, Action<XmlElement> action, int depth)
		{
			base.ForEach(baseNode, action, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// w肳ꂽm[hƂ̎q̃m[hɑ΂āAw肳ꂽs܂B
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		public void ForEach(XmlNode baseNode,
				Action<XmlElement> action, TreeSearchAlgorithm algorithm, int depth)
		{
			base.ForEach(baseNode, action, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override IEnumerable GetChildren(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(XmlNode));
			return ((XmlNode)node).ChildNodes;
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[ĥŌ̂̂擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="recurse"></param>
		/// <returns></returns>
		public override object GetLastChild(object node, bool recurse)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(XmlNode));
			XmlNode result = ((XmlNode)node).LastChild;
			if (recurse && result != null) {
				for (;;) {
					XmlNode child = result.LastChild;
					if (child == null) {
						break;
					}
					result = child;
				}
			}
			return result;
		}

		/// <summary>
		/// w肳ꂽm[h̒i邢͖jɂm[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override object GetNextSibling(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(XmlNode));
			return ((XmlNode)node).NextSibling;
		}

		/// <summary>
		/// w肳ꂽm[h̐em[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override object GetParent(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(XmlNode));
			return ((XmlNode)node).ParentNode;
		}

		/// <summary>
		/// w肳ꂽm[ȟZi邢͎ojɂm[h擾܂B
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override object GetPreviousSibling(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(XmlNode));
			return ((XmlNode)node).PreviousSibling;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="index"></param>
		public override void Insert(object parent, object child, int index)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(XmlNode));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(XmlNode));
			if (index < 0) {
				throw new ArgumentOutOfRangeException("index");
			}
			XmlNodeList children = ((XmlNode)parent).ChildNodes;
			if (index < children.Count) {
				((XmlNode)parent).InsertBefore((XmlNode)child, children[index]);
			} else {
				((XmlNode)parent).AppendChild((XmlNode)child);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		public void InsertSorted(XmlNode parent, XmlNode child, IComparer<XmlNode> comparer)
		{
			base.InsertSorted(parent, child, comparer);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparison"></param>
		public void InsertSorted(XmlNode parent, XmlNode child, Comparison<XmlNode> comparison)
		{
			base.InsertSorted(parent, child, comparison);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		public void InsertSorted(XmlNode parent, XmlElement child, IComparer<XmlElement> comparer)
		{
			base.InsertSorted(parent, child, comparer);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparison"></param>
		public void InsertSorted(
				XmlNode parent, XmlElement child, Comparison<XmlElement> comparison)
		{
			base.InsertSorted(parent, child, comparison);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hSč폜܂B
		/// </summary>
		/// <param name="node"></param>
		public override void RemoveAllChildren(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(XmlNode));
			var xn = (XmlNode)node;
			foreach (XmlNode child in xn.ChildNodes) {
				xn.RemoveChild(child);
			}
		}

		/// <summary>
		/// w肳ꂽqm[h폜܂B
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		public override void RemoveChild(object parent, object child)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(XmlNode));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(XmlNode));
			((XmlNode)parent).RemoveChild((XmlNode)child);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hבւ܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		public void Sort(XmlNode node, IComparer<XmlNode> comparer, bool recurse)
		{
			base.Sort(node, comparer, recurse);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hבւ܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparison"></param>
		/// <param name="recurse"></param>
		public void Sort(XmlNode node, Comparison<XmlNode> comparison, bool recurse)
		{
			base.Sort(node, comparison, recurse);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hבւ܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		public void Sort(XmlNode node, IComparer<XmlElement> comparer, bool recurse)
		{
			base.Sort(node, comparer, recurse);
		}

		/// <summary>
		/// w肳ꂽm[h̎qm[hבւ܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparison"></param>
		/// <param name="recurse"></param>
		public void Sort(XmlNode node, Comparison<XmlElement> comparison, bool recurse)
		{
			base.Sort(node, comparison, recurse);
		}
	}
}
