using System;
using System.IO;
using System.Xml;

using SystemNeo;

namespace SystemNeo.Xml
{
	/// <summary>
	/// XML Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class XmlUtil
	{
		// public static \bh //

		/// <summary>
		/// w肳ꂽȎvf擾郁\bh쐬܂B
		/// </summary>
		/// <param name="name"></param>
		/// <returns></returns>
		[Obsolete]
		public static Func<XmlElement, string> CreateAttributeGetter(string name)
		{
			return (element) => element.GetAttribute(name);
		}

		/// <summary>
		/// vf𕶎ɕϊ܂B
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		public static string ElementToString(XmlElement element)
		{
			return ElementToString(element, false);
		}

		/// <summary>
		/// vf𕶎ɕϊ܂B
		/// </summary>
		/// <param name="element"></param>
		/// <param name="withContent"></param>
		/// <returns></returns>
		public static string ElementToString(XmlElement element, bool withContent)
		{
			ArgumentUtil.AssertNull(element, "element");
			var settings = new XmlWriterSettings() {
				ConformanceLevel = ConformanceLevel.Fragment,
				OmitXmlDeclaration = true
			};
			var sw = new StringWriter();
			using (var xw = XmlWriter.Create(sw, settings)) {
				if (withContent) {
					element.WriteTo(xw);
				} else {
					ElementToStringInternal(element, xw);
				}
			}
			return sw.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <param name="name"></param>
		/// <returns></returns>
		public static string GetAttribute(XmlNode node, string name)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertNull(name, "name");
			try {
				return node.Attributes[name].Value;
			} catch (NullReferenceException) {
				return string.Empty;
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <param name="xw"></param>
		private static void ElementToStringInternal(XmlElement element, XmlWriter xw)
		{
			xw.WriteStartElement(element.Prefix, element.LocalName, element.NamespaceURI);
			foreach (XmlAttribute attr in element.Attributes) {
				attr.WriteTo(xw);
			}
			xw.WriteEndElement();
		}
	}
}
