using System;
using System.IO;
using System.Net;
using System.Text;
using SystemNeo.Net;
using NUnit.Framework;

namespace SystemNeoTest.Net.WebClientExTest
{
	internal class TestUtil
	{
		internal const string GOOGLE_TEST = @"<meta http-equiv=""content-type"" content=""text/html;"
										  + @" charset=Shift_JIS""><meta ";
	}

	[TestFixture]
	public class DownloadData
	{
		[Test]
		public void Normal()
		{
			// 
			WebRequest request = WebRequest.Create(new Uri("http://www.google.co.jp/"));
			var ms = new MemoryStream();

			// s
			new WebClientEx(request).DownloadData(ms, false);

			// 
			ms.Position = 0;
			var reader = new StreamReader(ms, Encoding.UTF8);
			string s1 = reader.ReadToEnd();
			string s2 = s1.Replace(TestUtil.GOOGLE_TEST, "");
			Assert.AreNotEqual(s1, s2);
		}
	}

	[TestFixture]
	public class DownloadString
	{
		[Test]
		public void Normal()
		{
			// 
			WebRequest request = WebRequest.Create(new Uri("http://www.google.co.jp/"));

			// s
			string result = new WebClientEx(request).DownloadString(Encoding.Default, true);

			// 
			Assert.AreNotEqual(result.Replace(TestUtil.GOOGLE_TEST, ""), result);
		}
	}
}
