﻿using System;
using System.Collections.Generic;
using SystemNeo;
using NUnit.Framework;

namespace SystemNeoTest.RandomNeoTest
{
	[TestFixture]
	public class NextWithWeight_int
	{
		[Test]
		public void Normal()
		{
			// 準備
			RandomNeo r = new RandomNeo();
			var dic = new Dictionary<int, int> {{0, 2}, {1, 5}, {2, 3}};
			int[] arr = {0, 0, 0};

			// 実行
			for (int i = 0; i < 10000; i++) {
				int n = r.NextWithWeight(dic);
				arr[n]++;
			}

			// 検証
			Assert.That(arr[0], Is.InRange(2000 * 0.95, 2000 * 1.05));
			Assert.That(arr[1], Is.InRange(5000 * 0.95, 5000 * 1.05));
			Assert.That(arr[2], Is.InRange(3000 * 0.95, 3000 * 1.05));
		}
	}

	[TestFixture]
	public class NextWithWeight_double
	{
		[Test]
		public void Normal()
		{
			// 準備
			RandomNeo r = new RandomNeo();
			var dic = new Dictionary<int, double> {{0, 2.2}, {1, 4.5}, {2, 3.3}};
			int[] arr = {0, 0, 0};

			// 実行
			for (int i = 0; i < 10000; i++) {
				int n = r.NextWithWeight(dic);
				arr[n]++;
			}

			// 検証
			Assert.That(arr[0], Is.InRange(2200 * 0.95, 2200 * 1.05));
			Assert.That(arr[1], Is.InRange(4500 * 0.95, 4500 * 1.05));
			Assert.That(arr[2], Is.InRange(3300 * 0.95, 3300 * 1.05));
		}
	}
}
