using System;
using System.Collections.Generic;
using SystemNeo;
using NUnit.Framework;

namespace SystemNeoTest.StringUtilTest
{
	/// <summary>
	/// Capitalize \bh̃eXg
	/// </summary>
	[TestFixture]
	public class Capitalize
	{
		[Test]
		public void @null()
		{
			// 
			string value = null;

			// s
			string result = StringUtil.Capitalize(value);

			// 
			Assert.Null(result);
		}

		[Test]
		public void 󕶎()
		{
			// 
			string value = "";

			// s
			string result = StringUtil.Capitalize(value);

			// 
			Assert.AreEqual("", result);
		}

		[Test]
		public void ̕()
		{
			// 
			string value = "abc";

			// s
			string result = StringUtil.Capitalize(value);

			// 
			Assert.AreEqual("Abc", result);
		}

		[Test]
		public void 啶̕()
		{
			// 
			string value = "ABC";

			// s
			string result = StringUtil.Capitalize(value);

			// 
			Assert.AreEqual("ABC", result);
		}
	}

	[TestFixture]
	public class CreateEmptyArray
	{
		[Test]
		public void 0()
		{
			// s
			string[] result = StringUtil.CreateEmptyArray(0);

			// 
			Assert.AreEqual(0, result.Length);
		}

		[Test]
		public void 0ȊO()
		{
			// s
			string[] result = StringUtil.CreateEmptyArray(3);

			// 
			Assert.AreEqual(new string[] {"", "", ""}, result);
		}
	}

	/// <summary>
	/// PopLine \bh̃eXg
	/// </summary>
	[TestFixture]
	public class PopLine
	{
		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void @null()
		{
			// 
			string value = null;

			// s
			string result = StringUtil.PopLine(ref value);
		}

		[Test]
		public void 󕶎()
		{
			// 
			string value = "";

			// s
			string result = StringUtil.PopLine(ref value);

			// 
			Assert.AreEqual("", result);
			Assert.Null(value);
		}

		[Test]
		public void s܂܂Ȃ()
		{
			// 
			string value = "ABC";

			// s
			string result = StringUtil.PopLine(ref value);

			// 
			Assert.AreEqual("ABC", result);
			Assert.Null(value);
		}

		[Test]
		public void s܂ޕ()
		{
			// 
			string value = "ABC\r\nDEF\r\nGHI";

			// s
			string result = StringUtil.PopLine(ref value);

			// 
			Assert.AreEqual("ABC", result);
			Assert.AreEqual("DEF\r\nGHI", value);
		}
	}

	/// <summary>
	/// PopString \bh̃eXg
	/// </summary>
	[TestFixture]
	public class PopString
	{
		[Test]
		public void @null()
		{
			// 
			string value = null;
			char separator = '-';

			// s
			string result = StringUtil.PopString(ref value, separator);

			// 
			Assert.Null(result);
			Assert.Null(value);
		}

		[Test]
		public void ؂蕶܂܂Ȃ()
		{
			// 
			string value = "ABC";
			char separator = '-';

			// s
			string result = StringUtil.PopString(ref value, separator);

			// 
			Assert.AreEqual("ABC", result);
			Assert.AreEqual("", value);
		}

		[Test]
		public void ؂蕶܂()
		{
			// 
			string value = "03-4567-8901";
			char separator = '-';

			// s
			string result = StringUtil.PopString(ref value, separator);

			// 
			Assert.AreEqual("03", result);
			Assert.AreEqual("4567-8901", value);
		}
	}

	/// <summary>
	/// SplitLines \bh̃eXg
	/// </summary>
	[TestFixture]
	public class SplitLines
	{
		[Test]
		public void @null()
		{
			// 
			string value = null;

			// s
			IList<string> result = StringUtil.SplitLines(value);

			// 
			Assert.AreEqual(0, result.Count);
		}

		[Test]
		public void 󕶎()
		{
			// 
			string value = "";

			// s
			IList<string> result = StringUtil.SplitLines(value);

			// 
			Assert.That(result, Is.EquivalentTo(new string[] { "" }));
		}

		[Test]
		public void s܂܂Ȃ()
		{
			// 
			string value = "ABC";

			// s
			IList<string> result = StringUtil.SplitLines(value);

			// 
			Assert.That(result, Is.EquivalentTo(new string[] { "ABC" }));
		}

		[Test]
		public void ŝ()
		{
			// 
			string value = "\r\n";

			// s
			IList<string> result = StringUtil.SplitLines(value);

			// 
			Assert.That(result, Is.EquivalentTo(new string[] { "", "" }));
		}

		[Test]
		public void s܂ޕ()
		{
			// 
			string value = "ABC\r\nDEF\nGHI";

			// s
			IList<string> result = StringUtil.SplitLines(value);

			// 
			Assert.That(result, Is.EquivalentTo(new string[] { "ABC", "DEF", "GHI" }));
		}
	}
}
