#ifndef __GLMETASEQ_H__
#define __GLMETASEQ_H__

/*=========================================================================================
	^ZRCAō쐬f(*.mqo)OpenGLɓǂݍފ֐܂Ƃ߂C/C++pwb_
=========================================================================================*/

/*
GLMetaseq
The MIT License
Copyright (c) 2009 Sunao Hashimoto and Keisuke Konishi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


GLMetaseq
MITCZX
Copyright (c) 2009 Sunao Hashimoto and Keisuke Konishi

ȉɒ߂ɏ]A{\tgEFAъ֘Ãt@Ciȉu\tg
EFAvj̕擾邷ׂĂ̐lɑ΂A\tgEFA𖳐ɈƂ
ŋ܂Bɂ́A\tgEFA̕gpAʁAύXAAfځA
ЕzATuCZXA/܂͔̔錠Aу\tgEFA񋟂
ɓƂ錠Ɋ܂܂܂B 

L̒쌠\і{\A\tgEFÂׂĂ̕܂͏dvȕ
ɋLڂ̂Ƃ܂B 

\tgEFÁû܂܁vŁAł邩Öقł邩킸A̕ۏ
Ȃ񋟂܂Błۏ؂Ƃ́AiA̖ړIւ̓KA
NQɂĂ̕ۏ؂܂݂܂AɌ肳̂ł͂܂B 
҂܂͒쌠҂́A_sׁAs@sׁA܂͂ȊOł낤ƁA\tg
EFAɋN܂͊֘AA邢̓\tgEFA̎gp܂͂̑̈
Đ؂̐AQȂ̋`ɂĉ̐ӔCȂ
Ƃ܂B 
*/

/*
----------------------------------------------------------------------------------------
	1. ̃wb_gł̒ӓ_
----------------------------------------------------------------------------------------
  
	ǂݍ݉\ȃeNX`̉摜`bmpCtgaCjpegCpng
	@
	@@jpeg̓ǂݍ݂ɂJPEGCuilibjpeg.lib, jpeglib.hjʓrKv
	@@jpeg̓ǂݍ݂Lɂɂ́C̃wb_ DEF_USE_LIBJPEG  1 ɂ邱

	@	png̓ǂݍ݂ɂPNGCuilibpng.lib, zlib.lib, png.h ,zlib.hjʓrKv
	@@png̓ǂݍ݂Lɂɂ́C̃wb_ DEF_USE_LIBPNG   1 ɂ邱

	eNX`摜̃TCÝuӂ2nTCY(64,128,256c)̐`vɌ


----------------------------------------------------------------------------------------
	2. g(1) 1MQOt@Cǂݍŕ\ꍇ
----------------------------------------------------------------------------------------

	(1) iARToolKit̏ꍇCargInit()̌Ɏgpj

		mqoInit();

	(2) t@C̃f̓ǂݍ

		MQO_MODEL model;
		model = mqoCreateModel( "mario.mqo", 1.0 );

	(3) f̌Ăяo
		
		mqoCallModel( model );

	(4) f̏

		mqoDeleteModel( model );

	(5) IivOIɂĂj

		mqoCleanup();

----------------------------------------------------------------------------------------
	3. g(2) Aԃt@Cǂݍŕ\ꍇ
----------------------------------------------------------------------------------------

	(1) iARToolKit̏ꍇCargInit()̌Ɏgpj

		mqoInit();

	(2) AԃV[PX̍쐬
	
	  @Fmario0.mqo ` mario9.mqo ǂݍ

		MQO_SEQUENCE seq;
		seq = mqoCreateSequence( "mario%d.mqo", 10, 1.0 );

	(3) AԃV[PX̎wt[̌Ăяoii̓t[ԍj
		
		mqoCallSequence( seq, i );

	(4) AԃV[PX̏

		mqoDeleteSequence( seq );

	(5) IivOIɂĂj

		mqoCleanup();

----------------------------------------------------------------------------------------
	4. Ȏdl
----------------------------------------------------------------------------------------

	\@\
	ET|[gĂMQOt@C̃o[ẂuMetasequoia Ver1.0/2.0`2.4v

	EΉĂގ
	@Fij
	@eNX`}bviov}bvΉ^UV}bsÔ݁j

	EΉĂIuWFNg
	@\^\̐؂ւ
	@X[WO̗L
	@_@߂Ƃ̃X[WOp
	@_
	@ʏi_J[Ήj

	EȖʁEʁE]̂ɂ͔Ή
	E^{[͔Ή

	dl
	E`N͌Ƃđ啶Ə̋ʂȂƂɂȂĂ邪
	@ʂĂ܂ĂD
	EeNX`̃pXɑoCgĂ
	@̂Ȃ'\'(0x5c)'/'(0x2f)͂ĂƂ܂eNX`ǂ߂ȂD
	EF̃}eAɑΉĂȂD
	@Object`Nface`N̍ގCfbNXiM(%d)j-1ɖΉD

*/



/*=========================================================================
y[UCӂŐݒz
=========================================================================*/

#define MAX_TEXTURE				100			// eNX`̍ő舵
#define MAX_OBJECT				50			// 1MQOt@C̍őIuWFNg
#define SIZE_STR				256			// obt@̃TCY
#define DEF_IS_LITTLE_ENDIAN	1			// GfBAwiinteln=1j
#define DEF_USE_LIBJPEG			0			// libjpeg̎gpi1:gp 0:gpj
#define DEF_USE_LIBPNG			0			// libpng ̎gpi1:gp 0:gpj



/*=========================================================================
yRpCIvVz
=========================================================================*/

// JPEGgp
#ifdef D_JPEG
	#undef	DEF_USE_LIBJPEG
	#define	DEF_USE_LIBJPEG 1
#endif

// JPEGgpȂ
#ifdef D_NO_JPEG
	#undef	DEF_USE_LIBJPEG
	#define	DEF_USE_LIBJPEG 0
#endif

// PNGgp
#ifdef D_PNG
	#undef	DEF_USE_LIBPNG
	#define	DEF_USE_LIBPNG 1
#endif

// PNGgpȂ
#ifdef D_NO_PNG
	#undef	DEF_USE_LIBPNG
	#define	DEF_USE_LIBPNG 0
#endif


/*=========================================================================
ywb_z
=========================================================================*/

#ifdef WIN32
	#include <windows.h>
#else
	#ifndef MAX_PATH
		#define MAX_PATH    256
	#endif
	#ifndef TRUE
		#define TRUE    (1==1)
	#endif
	#ifndef FALSE
	    #define FALSE   (1!=1)
	#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifdef __APPLE__
	#include <OpenGL/gl.h>
	#include <OpenGL/glu.h>
	#include <GLUT/glut.h>
	#include <OpenGL/glext.h>
#else
	#include <GLES/gl.h>
//	#include <GL/glu.h>
//	#include <GL/glut.h>
	#include <GLES/glext.h>
#endif


/*=========================================================================
y@\ݒz libjpeggpݒ
=========================================================================*/

#if DEF_USE_LIBJPEG

	#define XMD_H // INT16INT32̍Ē`G[h
	#ifdef FAR
		#undef FAR
	#endif

	#include "jpeglib.h"
	#pragma comment(lib,"libjpeg.lib")

#endif


/*=========================================================================
y@\ݒz libpnggpݒ
=========================================================================*/

#if DEF_USE_LIBPNG

	#include "png.h"
	#include "zlib.h"
	#pragma comment(lib,"libpng.lib")
	#pragma comment(lib,"zlib.lib")

#endif


/*=========================================================================
y}N`z ől}N
=========================================================================*/

#ifndef MAX
	#define MAX(a, b)  (((a) > (b)) ? (a) : (b))
#endif


/*=========================================================================
y^`z TGAtH[}bg
=========================================================================*/

#define DEF_TGA_COLOR_MAP_FLAG_VALID	1
#define DEF_TGA_TYPE_NON				0
#define DEF_TGA_TYPE_INDEX				1
#define DEF_TGA_TYPE_FULL				2
#define DEF_TGA_TYPE_MONO				3
#define DEF_TGA_TYPE_RLEINDEX			9
#define DEF_TGA_TYPE_RLEFULL			10
#define DEF_TGA_TYPE_RLEMONO			11
#define DEF_TGA_BIT_INFO_RIGHT_TO_LEFT	0x00
#define DEF_TGA_BIT_INFO_LEFT_TO_RIGHT	0x10
#define DEF_TGA_BIT_INFO_DOWN_TO_TOP	0x00
#define DEF_TGA_BIT_INFO_TOP_TO_DOWN	0x20

typedef struct {
	unsigned char	id;
	unsigned char	color_map_flag;
	unsigned char	type;
	unsigned short	color_map_entry;
	unsigned char	color_map_entry_size;
	unsigned short	x;
	unsigned short	y;
	unsigned short	width;
	unsigned short	height;
	unsigned char	depth;
	unsigned char	bit_info;
} STR_TGA_HEAD;


/*=========================================================================
y^`z OpenGLpF\ (4Ffloat)
=========================================================================*/
typedef struct {
	GLfloat r;
	GLfloat g;
	GLfloat b;
	GLfloat a;
} glCOLOR4f;


/*=========================================================================
y^`z OpenGLpQW\ (float)
=========================================================================*/
typedef struct {
	GLfloat x;
	GLfloat y;
} glPOINT2f;


/*=========================================================================
y^`z OpenGLpRW\ (float)
=========================================================================*/
typedef struct tag_glPOINT3f {
	GLfloat x;
	GLfloat y;
	GLfloat z;
} glPOINT3f;


/*=========================================================================
y^`z ʏ\
=========================================================================*/
typedef struct {
	int			n;		// 1̖ʂ\钸_̐i3`4j
	int			m;		// ʂ̍ގԍ
	int			v[4];	// _ԍi[z
	glPOINT2f	uv[4];	// UV}bv
} MQO_FACE;


/*=========================================================================
y^`z ގ\́it@CǂݍލۂɎgpj
=========================================================================*/
typedef struct {
	glCOLOR4f	col;				// F
	GLfloat		dif[4];				// gU
	GLfloat		amb[4];				// ͌
	GLfloat		emi[4];				// ȏƖ
	GLfloat		spc[4];				// ˌ
	GLfloat		power;				// ˌ̋
	int			useTex;				// eNX`̗L
	char		texFile[SIZE_STR];	// eNX`t@C
	char		alpFile[SIZE_STR];	// At@eNX`t@C
	GLuint		texName;			// eNX`
} MQO_MATDATA;


/*=========================================================================
y^`z IuWFNg\́ip[cP̃f[^j
=========================================================================*/
typedef struct {
	char		objname[SIZE_STR];	// p[c
	int			visible;			// 
	int			shading;			// VF[fBOi0:tbg^1:O[j
	float		facet;				// X[WOp
	int			n_face;				// ʐ
	int			n_vertex;			// _
	MQO_FACE	*F;					// 
	glPOINT3f	*V;					// _
} MQO_OBJDATA;


/*=========================================================================
y^`z eNX`v[
=========================================================================*/
typedef struct {
	GLuint			texture_id;			// eNX`ID
	int				texsize;			// eNX`TCY
	char			texfile[MAX_PATH];	// eNX`t@C
	char			alpfile[MAX_PATH];	// At@eNX`t@C
	unsigned char	alpha;				// At@
} TEXTURE_POOL;


/*=========================================================================
y^`z _f[^ieNX`gpj
=========================================================================*/
typedef struct {		
	GLfloat point[3];	// _z (x, y, z)
	GLfloat normal[3];	// @z (x, y, z)
	GLfloat uv[2];		// UVz (u, v)
} VERTEX_TEXUSE;


/*=========================================================================
y^`z _f[^ieNX`sgpj
=========================================================================*/
typedef struct {
	GLfloat point[3];	// _z (x, y, z)
	GLfloat normal[3];	// @z (x, y, z)
} VERTEX_NOTEX;


/*=========================================================================
y^`z }eAi}eAʂɒ_zj
=========================================================================*/
typedef struct {
	int				isValidMaterialInfo;// }eA̗L/
	int				isUseTexture;		// eNX`̗LFUSE_TEXTURE / NOUSE_TEXTURE
	GLuint			texture_id;			// eNX`̖O(OpenGL)
	GLuint			VBO_id;				// _obt@ID(OpenGL)@ΉĂ鎞gp
	int				datanum;			// _
	GLfloat			color[4];			// Fz (r, g, b, a)
	GLfloat			dif[4];				// gU
	GLfloat			amb[4];				// ͌
	GLfloat			emi[4];				// ȏƖ
	GLfloat			spc[4];				// ˌ
	GLfloat			power;				// ˌ̋
	VERTEX_NOTEX	*vertex_p;			// |Ŝ݂̎̒_z
	VERTEX_TEXUSE	*vertex_t;			// eNX`gp̒_z
} MQO_MATERIAL;


/*=========================================================================
y^`z IuWFNgi1̃p[cǗj
=========================================================================*/
typedef struct {
	char			objname[SIZE_STR];		// IuWFNg
	int				isVisible;				// 0F\@̑F\
	int				isShadingFlat;			// VF[fBO[h
	int				matnum;					// gp}eA
	MQO_MATERIAL	*mat;					// }eAz
} MQO_INNER_OBJECT;


/*=========================================================================
y^`z MQOIuWFNgi1̃fǗj@MQO_MODEL̎
=========================================================================*/
typedef struct {
	unsigned char		alpha;				// _z쐬Ɏw肳ꂽAt@liQƗpj
	int					objnum;				// IuWFNg
	MQO_INNER_OBJECT	obj[MAX_OBJECT];	// IuWFNgz
} MQO_OBJECT;


/*=========================================================================
y^`z MQO_MODEL\
=========================================================================*/
typedef MQO_OBJECT * MQO_MODEL;		// MQO_MODEL͓Ǝ`\̂ւ̃AhX


/*=========================================================================
y^`z MQOV[PX
=========================================================================*/
typedef struct {
	MQO_MODEL	model;		// f
	int			n_frame;	// t[
} MQO_SEQUENCE;


/*=========================================================================
y^`z glext.h  VBO Extension ̒`
=========================================================================*/
#ifdef WIN32
	#define GL_ARRAY_BUFFER_ARB	0x8892
	#define GL_STATIC_DRAW_ARB	0x88E4
	typedef void (APIENTRY * PFNGLBINDBUFFERARBPROC)    (GLenum target, GLuint buffer);
	typedef void (APIENTRY * PFNGLDELETEBUFFERSARBPROC) (GLsizei n, const GLuint *buffers);
	typedef void (APIENTRY * PFNGLGENBUFFERSARBPROC)    (GLsizei n, GLuint *buffers);
	typedef void (APIENTRY * PFNGLBUFFERDATAARBPROC)    (GLenum target, int size, const GLvoid *data, GLenum usage);
#endif


/*=========================================================================
yO[oϐ`z
=========================================================================*/

#ifdef __GLMETASEQ_C__
	#define __GLMETASEQ_C__EXTERN
#else
	#define __GLMETASEQ_C__EXTERN extern
#endif

__GLMETASEQ_C__EXTERN int g_isVBOSupported;	// OpenGL̒_obt@̃T|[gL

#ifdef WIN32	
	// VBO Extension ֐̃|C^
	__GLMETASEQ_C__EXTERN PFNGLGENBUFFERSARBPROC glGenBuffersARB;		// VBO O
	__GLMETASEQ_C__EXTERN PFNGLBINDBUFFERARBPROC glBindBufferARB;		// VBO т
	__GLMETASEQ_C__EXTERN PFNGLBUFFERDATAARBPROC glBufferDataARB;		// VBO f[^[h
	__GLMETASEQ_C__EXTERN PFNGLDELETEBUFFERSARBPROC glDeleteBuffersARB;	// VBO 폜
#endif

#undef __GLMETASEQ_C__EXTERN


/*=========================================================================
y֐錾z
=========================================================================*/

#ifdef __cplusplus
extern "C" {
#endif


// 
void mqoInit(void);

// I
void mqoCleanup(void);

// f
MQO_MODEL	 mqoCreateModel(char *filename, double scale);

// V[PX
MQO_SEQUENCE mqoCreateSequence(const char *format, int n_file, double scale);

// V[PXigŁj
MQO_SEQUENCE mqoCreateSequenceEx(const char *format, int n_file, double scale,
								 int fade_inout, unsigned char alpha);

// fĂяo
void mqoCallModel(MQO_MODEL model);

// V[PXĂяo
void mqoCallSequence(MQO_SEQUENCE seq, int i);

// f̍폜
void mqoDeleteModel(MQO_MODEL model);

// V[PX̍폜
void mqoDeleteSequence(MQO_SEQUENCE seq);


#ifdef __cplusplus
}
#endif




#endif	// -- end of header --

