#include <AR/param.h>
#include <AR/matrix.h>
#include <AR/ar.h>


ARDBL MulARDBL( ARDBL a, ARDBL b )
{
  long ah,bh;
	unsigned long long al,bl;
	long long t;
	ARDBL ans;
	
	if ( a==0 || b==0 )
		return 0;

	ah = (long)(a >> 32); 
  bh = (long)(b >> 32); 
  al = (unsigned long)a;
  bl = (unsigned long)b;

	ans = (al * bl) >> 32;
	ans += al * bh;
	ans += bl * ah;
	t = ah * (long long)bh;
	ans += t << 32;
	if ( ((long)t)>>31 != (long)(t>>32) )
	{
//		dbgBreak();
		if ( ((a >> 63)&1) ^ ((b>>63)&1) )
			ans = 0x8000000000000000ULL;
		else
			ans = 0x7fffffffffffffffULL;
	}

	return ans;
}

ARDBL DivARDBL( ARDBL a, ARDBL b )
{
	ARDBL r;
	unsigned long long x, y;
	unsigned long long ua, ub;
	unsigned long c;
	int i, sign = 0;

	if ( b == 0 )
	{
		dbgBreak();
		r = a/b;	// division by zero
	}
	if ( a < 0 )
	{
		ua = -a;
		sign++;
	}
	else
		ua = a;
	if ( b < 0 )
	{
		ub = -b;
		sign++;
	}
	else 
		ub = b;

	x = ua >> 32;
	y = 0;
	if ( x >= ub )
	{
		dbgBreak();
		if ( sign & 1 )
			return 0x8000000000000000ULL;
		else
			return 0x7fffffffffffffffULL;
	}
	c = (unsigned long)ua;

	for ( i=0; i<32; i++ )
	{
		x <<= 1;
		x |= (c >> 31) & 1;
		c <<= 1;
		y <<= 1;
		if ( x >= ub )
		{
			x -= ub;
			y |= 1;
		}
	}
	for ( i=0; i<32; i++ )
	{
		x <<= 1;
		y <<= 1;
		if ( x >= ub )
		{
			x -= ub;
			y |= 1;
		}
	}

	if ( sign & 1 )
		r = -(long long)y;
	else
		r = (long long)y;

	if ( r==0 && a )
	{
		r = (sign & 1)? 1:-1;
		//dbgBreak();
	}
	return r;
}

ARDBL SqrtARDBL( ARDBL x )
{
	if ( x < 0 )
	{
		dbgBreak();
		return 1LL<<32;
	}
	if ( x == 0 )
		return 0;
	if ( x == 1LL<<32 )
		return x;
	{		
#if 0
		long d;
		long long r2;
		unsigned long r;

		if ( x >= 0xffffffffULL * 0xffffffffULL )
		{
			r = 0xffffffffULL;
		}
		else
		{
			if ( x >= 1LL<<62 )
				r = (1UL<<31) + (1UL<<30);
			else
				r = 1UL<<30;

			for ( d=1<<29; d; d>>=1 )
			{
				r2 = r*(long long)r;
				if ( x >= r2 )
					r += d;
				else
					r -= d;
			} 
			r2 = r*(long long)r;
			if ( x > r2 ) 
	  		r++;
			else
			if ( x < r2 ) 
	  		r--;

			if ( r==0 && x )
			{
				r = 1;
				dbgBreak();
			}
		}
		return ((ARDBL)r)<<16;
#else
		unsigned long long vL,vH, tL,tH, cH, b, z, y;
		int sft;
		vH = ((unsigned long long)x) >> (64 - (32-2));
		vL = ((unsigned long long)x) << (32-2);

		for ( b=1ULL<<(63-2), y=0, sft=63-2;  b;  b>>=1, sft-- )
		{
			z = b + 2*y;
			tH = z >> (64 - sft);
			tL = z << sft;

			// c = v - t
			cH = vH - tH;
			if ( vL < tL )
				cH--;
			if ( (cH >> 63) == 0 )
			{
				vH = cH;
				vL = vL - tL;
				y += b;
			}
		}
		y <<= 1;
		return y;
		/*
		unsigned long long v=x, t;
		unsigned long b, r;
		int sft;
		for ( b=1UL<<31, r=0, sft=31;  b;  b>>=1, sft-- )
		{
			t = (b + r+(unsigned long long)r) << sft;
			if ( v >= t )
			{
				v -= t;
				r += b;
			}
		}
		return ((ARDBL)r)<<16;*/
#endif
	}
}

int SqrtInt( int x )
{
	unsigned long v=x, t;
	unsigned long b, r;
	int sft;

	if ( x < 0 )
	{
		dbgBreak();
		return 1;
	}
	if ( x == 0 )
		return 0;
	if ( x == 1 )
		return x;

	for ( b=1<<15, r=0, sft=15;  b;  b>>=1, sft-- )
	{
		t = (b + 2*r) << sft;
		if ( v >= t )
		{
			v -= t;
			r += b;
		}
	}
	return r;
}

ARDBL InvSqrtARDBL( ARDBL x )
{
	unsigned long long r = (1ULL<<63) / (unsigned long long)SqrtARDBL( x );
	r <<= 1;
	if ( r==0 && x )
	{
		r = 1;
		dbgBreak();
	}
	return (ARDBL)r;
}

ARDBL productL28x3toARDBL( long v0, long v1, long v2 )
{
	long long a, ah;
	unsigned long long al;
	ARDBL ans;
	
	a = v0 * (long long)v1;

	ah = a >> 32; 
  al = a & ((1LL<<32)-1);

	ans = (al * (long long)v2) >> 32;
	ans += v2 * ah;
	ans >>= 20;
	return ans;
}

ARDBL productL28x4toARDBL( long v0, long v1, long v2, long v3 )
{
	long long a, b;
  long long ah,bh;
	unsigned long long al,bl;
	ARDBL ans;
	
	a = v0 * (long long)v1;
	b = v2 * (long long)v3;

	ah = a >> 32; 
  bh = b >> 32; 
  al = a & ((1LL<<32)-1);
  bl = b & ((1LL<<32)-1);

	ans = (al * bl) >> 32;
	ans += al * bh;
	ans += bl * ah;
	ans >>= 32;
	ans += ah * bh;
	ans >>= 16;
	return ans;
}

