/*******************************************************
 *
 * Author: Shinsaku Hiura, Hirokazu Kato
 *
 *         shinsaku@sys.es.osaka-u.ac.jp
 *         kato@sys.im.hiroshima-cu.ac.jp
 *
 * Revision: 2.1
 * Date: 99/07/16
 *
*******************************************************/
#include <stdio.h>
#include <math.h>
#include <AR/matrix.h>

int arMatrixMul(ARMat *dest, ARMat *a, ARMat *b)
{
	int r, c, i;

	if(a->clm != b->row || dest->row != a->row || dest->clm != b->clm) return -1;

	for(r = 0; r < dest->row; r++) {
		for(c = 0; c < dest->clm; c++) {
			ARELEM0(dest, r, c) = 0;
			for(i = 0; i < a->clm; i++) {
				ARELEM0(dest, r, c) += MulARVAL( ARELEM0(a, r, i), ARELEM0(b, i, c) );
			}
		}
	}

	return 0;
}

int arMatrixMulShift( ARMat *dest, int *destShift, ARMat *a, ARMat *b, int srcShift )
{
	int r, c, i;
	const ARVAL argmax = (1LL<<((sizeof(ARVAL)*8-REALBITS_ARVAL) - 1)) - 1;
	ARVAL v0, v1;
	long long vt;
	int curShift, s;

	if(a->clm != b->row || dest->row != a->row || dest->clm != b->clm) return -1;
	curShift = 0;

	for(r = 0; r < dest->row; r++) {
		for(c = 0; c < dest->clm; c++) {
			ARELEM0(dest, r, c) = 0;
			for(i = 0; i < a->clm; i++) {
				v0 = ARELEM0(a, r, i);
				v1 = ARELEM0(b, i, c);
				s = srcShift - curShift;
				if ( s > 0 )
				{
					if ( v0 > v1 )
						v1 <<= s;
					else
						v0 <<= s;
				}
				else
				{
					if ( v0 > v1 )
						v0 >>= -s;
					else
						v1 >>= -s;
				}
				v0 = AbsARVAL( v0 );
				v1 = AbsARVAL( v1 );
				vt = (v0 >> REALBITS_ARVAL) * (long long)(v1 >> REALBITS_ARVAL);
				for ( s = 0;  vt > argmax;  s++ )
				{
					vt >>= 1;
				}
				curShift += s;
			}
		}
	}
	
	for(r = 0; r < dest->row; r++) {
		for(c = 0; c < dest->clm; c++) {
			ARELEM0(dest, r, c) = 0;
			for(i = 0; i < a->clm; i++) {
				v0 = ARELEM0(a, r, i);
				v1 = ARELEM0(b, i, c);
				s = srcShift - curShift;
				if ( s > 0 )
				{
					if ( v0 > v1 )
						v1 <<= s;
					else
						v0 <<= s;
				}
				else
				{
					if ( v0 > v1 )
						v0 >>= -s;
					else
						v1 >>= -s;
				}
				ARELEM0(dest, r, c) += MulARVAL( v0, v1 );
			}
		}
	}
	*destShift = curShift;
	
	return 0;
}
